/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.stateless.template.runtime;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import jetbrains.mps.webr.stateless.template.dependency.DependencyCollection;
import webr.framework.textBuilder.WebrBuffer;

public class TemplateBuilderContext
extends WebrBuffer {
    private Writer out;
    private long created;
    private DependencyCollection jsDependencyCollection = new DependencyCollection();
    private DependencyCollection cssDependencyCollection = new DependencyCollection();

    TemplateBuilderContext(OutputStream outputStream) {
        this.out = new BufferedWriter(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8));
        this.created = System.nanoTime();
    }

    TemplateBuilderContext(Writer writer) {
        this.out = writer;
        this.created = System.nanoTime();
    }

    void close() throws IOException {
        this.out.close();
    }

    public long getTimeSpent() {
        return System.nanoTime() - this.created;
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void append(String text) {
        this.write(text);
    }

    public void append(int i) {
        this.write(String.valueOf(i));
    }

    public void appendNewLine() {
        this.write("\n");
    }

    public void appendIndent() {
        this.append(SPACES[this.indent]);
    }

    public void increaseIndent() {
        this.indent = (byte)(this.indent + 1);
    }

    public void decreaseIndent() {
        this.indent = (byte)(this.indent - 1);
    }

    public void flushTo(Writer writer) {
        throw new UnsupportedOperationException();
    }

    public int getSize() {
        throw new UnsupportedOperationException();
    }

    public DependencyCollection getCssDependencyCollection() {
        return this.cssDependencyCollection;
    }

    public DependencyCollection getJsDependencyCollection() {
        return this.jsDependencyCollection;
    }

    private void write(String s) {
        try {
            this.out.write(s, 0, s.length());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

