/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.wiki.processor.runtime;

import java.util.ArrayList;
import java.util.List;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.mps.webr.wiki.processor.runtime.HtmlTextCallerProcessorMarkup;
import jetbrains.mps.webr.wiki.processor.runtime.HtmlTextCallerProcessorRemoveMarkup;
import jetbrains.mps.webr.wiki.processor.runtime.IWikiProcessor;
import jetbrains.mps.webr.wiki.processor.runtime.WikiBlockHelp;
import jetbrains.mps.webr.wiki.processor.runtime.WikiProcessor;
import jetbrains.mps.webr.wiki.processor.runtime.WikiUtil;
import jetbrains.springframework.configuration.runtime.ServiceLocator;

public class HtmlTextCallerProcessor
implements WikiProcessor {
    private static List<WikiBlockHelp> HELP;
    private static boolean HELP_READY;
    private static HtmlTextCallerProcessor INSTANCE;

    private HtmlTextCallerProcessor() {
    }

    public String clean(String arg) {
        if (arg == null) {
            return null;
        }
        int s = 0;
        for (int i = 0; i < arg.length(); ++i) {
            s += arg.charAt(i) == '\r' ? 0 : 1;
        }
        char[] ar = new char[s];
        s = 0;
        for (int i = 0; i < arg.length(); ++i) {
            if (arg.charAt(i) == '\r') continue;
            ar[s++] = arg.charAt(i);
        }
        return new String(ar);
    }

    @Override
    public IWikiProcessor createProcessor(String s) {
        HtmlTextCallerProcessorMarkup result = HtmlTextCallerProcessorMarkup.create(this.clean(s));
        result.setWrapWithDiv(true);
        return result;
    }

    @Override
    public IWikiProcessor createRemoveMarkupProcessor(String s) {
        HtmlTextCallerProcessorRemoveMarkup result = HtmlTextCallerProcessorRemoveMarkup.create(this.clean(s));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<WikiBlockHelp> getHelp() {
        if (!HELP_READY) {
            HtmlTextCallerProcessor htmlTextCallerProcessor = this;
            synchronized (htmlTextCallerProcessor) {
                if (!HELP_READY) {
                    HELP = ListSequence.fromList(new ArrayList());
                    ListSequence.fromList(HELP).addElement((Object)new WikiBlockHelp((_FunctionTypes._return_P0_E0<? extends String>)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("HtmlText.HtmlTextCaller", new Object[0]);
                        }
                    }, (_FunctionTypes._return_P0_E0<? extends String>)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return HtmlTextCallerProcessor.concat(new String[]{"{html}\n" + WikiUtil.getSampleHtml() + "\n{html}"});
                        }
                    }, true));
                    HELP_READY = true;
                }
            }
        }
        return HELP;
    }

    public static HtmlTextCallerProcessor getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new HtmlTextCallerProcessor();
        }
        return INSTANCE;
    }

    private static String concat(String ... strings) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < strings.length; ++i) {
            sb.append(strings[i]);
            if (i >= strings.length - 1) continue;
            sb.append('\n');
        }
        return sb.toString();
    }
}

