/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.wiki.processor.runtime;

import jetbrains.mps.gtext.runtime.TBaseBuilderContext;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.mps.webr.runtime.util.UserAgentUtil;
import jetbrains.mps.webr.runtime.util.UserBrowser;
import jetbrains.mps.webr.wiki.processor.runtime.IWikiProcessor;
import jetbrains.springframework.configuration.runtime.ServiceLocator;

public class WikiUtil {
    private static final String SAMPLE_STACKTRACE = "java.lang.NullPointerException\n\tat com.SomeClass.someMethod(SomeClass.java:20)\n\tat com.SomeClass.someMethod2(SomeClass.java:10)";
    private static String[] cutMarkup = new String[]{"<span class=\"wiki-plus", "\" onclick=\"WikiUtil.wikiCollapse(this)", "\"></span><span class=\"wiki-cut-title\">", "</span><span class=\"wiki-hellip\">&hellip;</span><div class=\"wiki-hidden\">", "</div>"};
    public static final String codeHelpSample1 = "{code lang=hs}\n-- Point-free style\nfib :: Integer -> Integer\nfib = (fibs !!)\n       where fibs = 0 : scanl (+) 1 fibs\n \n-- Explicit\nfib :: Integer -> Integer\nfib n = fibs !! n\n        where fibs = 0 : scanl (+) 1 fibs\n{code}\n\n```css\n.wikicode {\n  background-color: #f9f9f9;\n  border: 1px dashed  #2f6fab;\n  color: black;\n  line-height: 140%;\n  padding: 5px 10px;\n  overflow-x: auto;\n}\n```\n\n```\ninput.translate(string.maketrans(\"ATGC\", \"TACG\"))[::-1]\n```";
    public static final String codeHelpSample2 = "{code:lang=scala|title=Code}object HelloWorld {\n  def main(args: Array[String]) {\n    println(\"Hello, world!\")\n  }\n}{code}";
    public static final String PLAIN_TEXT = "text";
    private TBaseBuilderContext builderContext;

    public WikiUtil(TBaseBuilderContext builderContext) {
        this.builderContext = builderContext;
    }

    public void appendCutMarkup(String head, String body, IWikiProcessor processor, Boolean noJs) {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(cutMarkup[0]);
        if (!noJs.booleanValue()) {
            builderContext = this.builderContext;
            builderContext.append(cutMarkup[1]);
        }
        builderContext = this.builderContext;
        builderContext.append(cutMarkup[2]);
        builderContext = this.builderContext;
        builderContext.append(head);
        builderContext = this.builderContext;
        builderContext.append(cutMarkup[3]);
        processor.clone(body).processSafe(this.builderContext);
        builderContext = this.builderContext;
        builderContext.append(cutMarkup[4]);
    }

    public static String getSampleStackTrace() {
        return SAMPLE_STACKTRACE;
    }

    public static String newLine() {
        return UserAgentUtil.getUserBrowser() == UserBrowser.INTERNET_EXPLORER ? "\r\n" : "<br/>";
    }

    public static String getCodeHelpText() {
        return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("WikiUtil.Code_highlighter", new Object[0]) + "<br/><br/><div style=\"font-size: x-small;\">" + ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("WikiUtil.By_default_code_highlighter_supports_C_C_C#_Java_JavaScript_Perl_Python_Ruby_and_SH_languages", new Object[0]) + ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("WikiUtil.To_enable_highlighting_for_additional_languages_use", new Object[]{" <em>'lang=&lt;langname&gt;'</em> ", " <em>code</em> "}) + ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("WikiUtil.Supported_additional_languages", new Object[0]) + "apollo (AGC/AEA Assembly Language), css, hs (Haskell), lisp, lua, ml, scala, sql, vb, vhdl, wiki, yaml, tex, xq, tcl, proto, pascal, n (Nemerle), mumps, matlab, llvm, erlang, dart, clj (Clojure), basic, kt (Kotlin)</div>";
    }

    public static String getSampleHtml() {
        StringBuilder b = new StringBuilder("<div style=\"border-left: #0066cc solid 2px; padding-left: 6px\">\n    <a href=\"http://www.jetbrains.com/youtrack/\" target=\"blank\"><h4 style=\"margin:5px\">YouTrack</h4></a>\n    <b><i>");
        b.append(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("WikiUtil.Agile_Issue_Project_Tracker", new Object[0]));
        b.append("</i></b>\n</div>");
        return b.toString();
    }
}

