/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.wiki.processor.runtime.utils;

import java.util.ArrayList;
import java.util.regex.Matcher;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.webr.wiki.processor.runtime.utils.AttributeManufacture;
import jetbrains.mps.webr.wiki.processor.runtime.utils.HtmlAttribute;
import jetbrains.mps.webr.wiki.processor.runtime.utils.HtmlConstants;
import jetbrains.mps.webr.wiki.processor.runtime.utils.HtmlTag;
import jetbrains.mps.webr.wiki.processor.runtime.utils.StringUtils;
import jetbrains.mps.webr.wiki.processor.runtime.utils.TagTitle;

public class OpeningHtmlTag
extends HtmlTag {
    protected ArrayList<HtmlAttribute> attributes = new ArrayList();
    protected boolean isSingletonTag;
    private AttributeManufacture manufacture;
    private String additionalCssStyle;

    public OpeningHtmlTag(String text) {
        this(text, null, "");
    }

    public OpeningHtmlTag(String text, String additionalCssStyle) {
        this(text, null, additionalCssStyle);
    }

    public OpeningHtmlTag(String text, AttributeManufacture manufacture) {
        this(text, manufacture, "");
    }

    public OpeningHtmlTag(String text, AttributeManufacture manufacture, String additionalCssStyle) {
        super(text);
        this.manufacture = manufacture;
        this.additionalCssStyle = additionalCssStyle;
        this.init();
    }

    public boolean isSingletonTag() {
        return this.isSingletonTag;
    }

    @Override
    public boolean isOpeningTag() {
        return true;
    }

    @Override
    protected void parse(String parsingString) {
        int endOfTag = parsingString.indexOf(">") + 1;
        if (endOfTag <= 2) {
            return;
        }
        boolean hasNoSlashAtTheEnd = parsingString.charAt(endOfTag - 2) != '/';
        Matcher matcher = HtmlConstants.END_OF_TAG_TITLE.matcher(parsingString);
        if (!matcher.find()) {
            return;
        }
        int endOfTagTitle = matcher.start();
        this.tagTitle = TagTitle.parse(StringUtils.substring(parsingString, 1, endOfTagTitle));
        if (this.tagTitle == null) {
            return;
        }
        boolean bl = this.isSingletonTag = !hasNoSlashAtTheEnd;
        if (this.manufacture != null) {
            if (endOfTag - endOfTagTitle > 1) {
                int endOfAttributes = hasNoSlashAtTheEnd ? endOfTag - 1 : endOfTag - 2;
                this.attributes = this.manufacture.getAttributes(StringUtils.substring(parsingString, endOfTagTitle, endOfAttributes), this.tagTitle, this.additionalCssStyle);
            } else {
                this.attributes = this.manufacture.getAttributes(this.tagTitle, this.additionalCssStyle);
            }
        }
    }

    @Override
    protected String stringPresentation() {
        StringBuilder builder = new StringBuilder("<");
        builder.append(this.getTagTitle().toString());
        for (HtmlAttribute item : ListSequence.fromList(this.attributes)) {
            if (OpeningHtmlTag.isEmpty_fk2vgr_a0a0a2a3_0(item.getKey()) || OpeningHtmlTag.isEmpty_fk2vgr_a0a0a2a3(item.getValue())) continue;
            builder.append(" ");
            builder.append(item.getKey());
            builder.append("=\"");
            builder.append(item.getValue());
            builder.append("\"");
        }
        if (this.isSingletonTag()) {
            builder.append("/");
        }
        builder.append(">");
        return builder.toString();
    }

    public static boolean isEmpty_fk2vgr_a0a0a2a3(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isEmpty_fk2vgr_a0a0a2a3_0(String str) {
        return str == null || str.length() == 0;
    }
}

