/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.teamsys.license.runtime;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;

public class LicenseUtil {
    public static final int PUBLIC_KEY_BITLEN = 1024;
    public static final int MD5_BITLEN = 128;
    public static final BigInteger ZERO = BigInteger.valueOf(0L);
    public static final BigInteger ONE = BigInteger.valueOf(1L);
    public static final BigInteger TWO = BigInteger.valueOf(2L);
    public static final BigInteger THREE = BigInteger.valueOf(3L);
    public static final BigInteger FOUR = BigInteger.valueOf(4L);
    private static final BigInteger FIRST_PRIMES_MULTIPLE = BigInteger.valueOf(111546435L);
    private static Random rnd = new Random();

    private LicenseUtil() {
    }

    public static BigInteger getUsernameMD5(String username) {
        MessageDigest md5 = LicenseUtil.getMD5();
        try {
            md5.update(username.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return new BigInteger(1, md5.digest());
    }

    public static BigInteger getLicenseMD5(BigInteger license) {
        MessageDigest md5 = LicenseUtil.getMD5();
        md5.update(license.toByteArray());
        return new BigInteger(1, md5.digest());
    }

    public static BigInteger[] generatePrivateKeyPair(final _FunctionTypes._void_P1_E0<? super String> progress) {
        BigInteger[] result = new BigInteger[2];
        int smallerPrimeLen = 511;
        final int[] candidates = new int[1];
        _FunctionTypes._void_P1_E0<String> progress1 = new _FunctionTypes._void_P1_E0<String>(){

            public void invoke(String message) {
                candidates[0] = candidates[0] + 1;
                progress.invoke((Object)("Generating first prime: " + message + ". Total candidates: " + candidates[0]));
            }
        };
        result[0] = LicenseUtil.generatePrime(511, (_FunctionTypes._void_P1_E0<? super String>)(progress == null ? null : progress1));
        _FunctionTypes._void_P1_E0<String> progress2 = new _FunctionTypes._void_P1_E0<String>(){

            public void invoke(String message) {
                candidates[0] = candidates[0] + 1;
                progress.invoke((Object)("Generating second prime: " + message + ". Total candidates: " + candidates[0]));
            }
        };
        result[1] = LicenseUtil.generatePrime(513, (_FunctionTypes._void_P1_E0<? super String>)(progress == null ? null : progress2));
        return result;
    }

    public static BigInteger generatePrime(int bitLen, _FunctionTypes._void_P1_E0<? super String> progress) {
        int candidates = 0;
        BigInteger t = new BigInteger(bitLen - 1, rnd).setBit(0).setBit(bitLen - 1);
        BigInteger result = ONE.add(t.shiftLeft(1));
        while (true) {
            if (progress != null) {
                progress.invoke((Object)(++candidates + " candidates"));
            }
            if (FIRST_PRIMES_MULTIPLE.gcd(t).equals(ONE) && FIRST_PRIMES_MULTIPLE.gcd(result).equals(ONE) && LicenseUtil.isStrongPseudoprimeInNRandomBases(result, 1000) && LicenseUtil.isStrongPseudoprimeInNRandomBases(t, 1000)) break;
            t = t.add(TWO);
            result = result.add(FOUR);
        }
        return result;
    }

    public static boolean isStrongPseudoprimeInNRandomBases(BigInteger candidate, int n) {
        while (n > 0) {
            --n;
            if (LicenseUtil.isStrongPseudoprime(candidate, BigInteger.valueOf(Math.abs(rnd.nextLong())))) continue;
            return false;
        }
        return true;
    }

    public static boolean isStrongPseudoprime(BigInteger candidate, BigInteger base) {
        BigInteger minus_one;
        BigInteger d = minus_one = candidate.subtract(ONE);
        while (d.testBit(0)) {
            d = d.shiftRight(1);
        }
        BigInteger t = base.modPow(d, candidate);
        if (t.equals(ONE) || t.equals(minus_one)) {
            return true;
        }
        BigInteger i = d.shiftLeft(1);
        while (i.compareTo(minus_one) < 0) {
            if (base.modPow(i, candidate).equals(minus_one)) {
                return true;
            }
            i = i.shiftLeft(1);
        }
        return false;
    }

    public static long powerOf2(int exponent) {
        return 1L << exponent;
    }

    private static MessageDigest getMD5() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        for (int i = 0; i < 1000; ++i) {
            rnd.nextLong();
        }
    }
}

