/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.baseLanguage.closures.runtime;

import jetbrains.mps.baseLanguage.closures.runtime.Outcome;

public class Result<T, R> {
    public static Result<Object, Object> RETURN_VOID = new Result(Outcome.RETURN_VOID);
    public static Result<Object, Object> TERMINATE_VOID = new Result(Outcome.TERMINATE_VOID);
    public static Result<Object, Object> BREAK = new Result(Outcome.BREAK);
    public static Result<Object, Object> NONE = new Result(Outcome.NONE);
    private Outcome outcome;
    private String breakLabel;
    private R retVal;
    private T termVal;

    private Result(Outcome outcome, T termVal, R retVal) {
        this.outcome = outcome;
        this.termVal = termVal;
        this.retVal = retVal;
    }

    private Result(Outcome outcome) {
        this.outcome = outcome;
    }

    private Result(String label) {
        this.outcome = Outcome.BREAK;
        this.breakLabel = label;
    }

    public Outcome getOutcome() {
        return this.outcome;
    }

    public R returnObject() {
        return this.getRetVal();
    }

    public T terminateObject() {
        return this.getTermVal();
    }

    public boolean returnBoolean() {
        return (Boolean)this.getRetVal();
    }

    public boolean terminateBoolean() {
        return (Boolean)this.getTermVal();
    }

    public byte returnByte() {
        return (Byte)this.getRetVal();
    }

    public byte terminateByte() {
        return (Byte)this.getTermVal();
    }

    public char returnChar() {
        return ((Character)this.getRetVal()).charValue();
    }

    public char terminateChar() {
        return ((Character)this.getTermVal()).charValue();
    }

    public double returnDouble() {
        return (Double)this.getRetVal();
    }

    public double terminateDouble() {
        return (Double)this.getTermVal();
    }

    public float returnFloat() {
        return ((Float)this.getRetVal()).floatValue();
    }

    public float terminateFloat() {
        return ((Float)this.getTermVal()).floatValue();
    }

    public int returnInt() {
        return (Integer)this.getRetVal();
    }

    public int terminateInt() {
        return (Integer)this.getTermVal();
    }

    public long returnLong() {
        return (Long)this.getRetVal();
    }

    public long terminateLong() {
        return (Long)this.getTermVal();
    }

    public short returnShort() {
        return (Short)this.getRetVal();
    }

    public short terminateShort() {
        return (Short)this.getTermVal();
    }

    public String getBreakLabel() {
        return this.breakLabel;
    }

    private R getRetVal() {
        switch (this.outcome) {
            case RETURN_VALUE: {
                return this.retVal;
            }
        }
        throw new IllegalStateException();
    }

    private T getTermVal() {
        switch (this.outcome) {
            case TERMINATE_VALUE: {
                return this.termVal;
            }
        }
        throw new IllegalStateException();
    }

    public static <U, S> Result<U, S> RETURN(S val) {
        return new Result<Object, S>(Outcome.RETURN_VALUE, null, val);
    }

    public static <U, S> Result<U, S> TERMINATE(U val) {
        return new Result<U, Object>(Outcome.TERMINATE_VALUE, val, null);
    }

    public static <U> Result<U, Object> RETURN_VOID() {
        return RETURN_VOID;
    }

    public static <S> Result<Object, S> TERMINATE_VOID() {
        return TERMINATE_VOID;
    }

    public static <U, V> Result<U, V> BREAK() {
        return BREAK;
    }

    public static <U, V> Result<U, V> BREAK(String label) {
        return new Result(label);
    }

    public static <U, V> Result<U, V> NONE() {
        return NONE;
    }
}

