/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.internal.collections.runtime;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import jetbrains.mps.baseLanguage.closures.runtime.AdapterClass;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.CollectionUtils;
import jetbrains.mps.internal.collections.runtime.ICollectionSequence;
import jetbrains.mps.internal.collections.runtime.ISequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internal.collections.runtime.impl.NullCollectionSequence;

public abstract class CollectionSequence<T>
extends Sequence<T>
implements ICollectionSequence<T>,
Collection<T>,
Serializable {
    private static final long serialVersionUID = -195412084368027561L;

    protected CollectionSequence() {
    }

    @Override
    public T addElement(T t) {
        if (this.getCollection().add(t)) {
            return t;
        }
        return null;
    }

    @Override
    public T removeElement(T t) {
        if (this.remove(t)) {
            return t;
        }
        return null;
    }

    @Override
    public ICollectionSequence<T> addSequence(ISequence<? extends T> seq) {
        if (seq == null) {
            return this;
        }
        if (seq.toIterable() instanceof Collection) {
            this.getCollection().addAll((Collection)seq.toIterable());
        } else {
            for (T t : seq.toIterable()) {
                this.getCollection().add(t);
            }
        }
        return this;
    }

    @Override
    public ICollectionSequence<T> removeSequence(ISequence<? extends T> seq) {
        if (seq == null) {
            return this;
        }
        if (seq.toIterable() instanceof Collection) {
            this.getCollection().removeAll((Collection)seq.toIterable());
        } else {
            for (T t : seq.toIterable()) {
                this.getCollection().remove(t);
            }
        }
        return this;
    }

    @Override
    public ICollectionSequence<T> removeWhere(@AdapterClass(value="IWhereFilter") _FunctionTypes._return_P1_E0<? extends Boolean, ? super T> filter) {
        Iterator<T> it = this.getCollection().iterator();
        while (it.hasNext()) {
            if (!((Boolean)filter.invoke(it.next())).booleanValue()) continue;
            it.remove();
        }
        return this;
    }

    @Override
    public boolean add(T e) {
        return this.getCollection().add(e);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        return this.getCollection().addAll(c);
    }

    @Override
    public void clear() {
        this.getCollection().clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.getCollection().contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.getCollection().containsAll(c);
    }

    @Override
    public boolean isEmpty() {
        return this.getCollection().isEmpty();
    }

    @Override
    public boolean remove(Object o) {
        return this.getCollection().remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.getCollection().removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.getCollection().retainAll(c);
    }

    @Override
    public int size() {
        return this.getCollection().size();
    }

    @Override
    public Object[] toArray() {
        return this.getCollection().toArray();
    }

    @Override
    public <U> U[] toArray(U[] a) {
        return this.getCollection().toArray(a);
    }

    @Override
    public Iterator<T> iterator() {
        return this.getCollection().iterator();
    }

    @Override
    public ICollectionSequence<T> asUnmodifiable() {
        final Collection<T> unmodifiableCollection = Collections.unmodifiableCollection(this.getCollection());
        return new CollectionSequence<T>(){

            @Override
            protected Collection<T> getCollection() {
                return unmodifiableCollection;
            }
        };
    }

    @Override
    public ICollectionSequence<T> asSynchronized() {
        final Collection synchronizedCollection = CollectionUtils.synchronizedCollection(this.getCollection());
        return new CollectionSequence<T>(){

            @Override
            protected Collection<T> getCollection() {
                return synchronizedCollection;
            }
        };
    }

    @Override
    public int count() {
        return this.getCollection().size();
    }

    @Override
    public boolean containsSequence(ISequence<T> that) {
        if (that instanceof CollectionSequence) {
            return this.getCollection().containsAll(((CollectionSequence)that).getCollection());
        }
        return super.containsSequence(that);
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof CollectionSequence) {
            Collection<T> thatColl = ((CollectionSequence)o).getCollection();
            Collection<T> thisColl = this.getCollection();
            if (thisColl == thatColl) {
                return true;
            }
            return thisColl != null ? ((Object)thisColl).equals(thatColl) : false;
        }
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return ((Object)this.getCollection()).hashCode();
    }

    protected abstract Collection<T> getCollection();

    public static <U> ICollectionSequence<U> fromCollection(final Collection<U> coll) {
        if (coll == null) {
            return NullCollectionSequence.instance();
        }
        if (coll instanceof ICollectionSequence) {
            return (ICollectionSequence)coll;
        }
        return new CollectionSequence<U>(){

            @Override
            protected Collection<U> getCollection() {
                return coll;
            }
        };
    }

    public static <U> ICollectionSequence<U> fromCollectionWithValues(Collection<U> coll, Iterable<? extends U> it) {
        Collection<U> tmp = coll;
        if (coll == null && it == null) {
            return NullCollectionSequence.instance();
        }
        if (coll == null) {
            tmp = new ArrayList<U>();
        } else if (it == null) {
            return CollectionSequence.fromCollection(coll);
        }
        if (it instanceof Collection) {
            tmp.addAll((Collection)it);
        } else {
            for (U u : it) {
                tmp.add(u);
            }
        }
        if (tmp instanceof ICollectionSequence) {
            return (ICollectionSequence)tmp;
        }
        final Collection<U> myColl = tmp;
        return new CollectionSequence<U>(){

            @Override
            protected Collection<U> getCollection() {
                return myColl;
            }
        };
    }

    public static <U> ICollectionSequence<U> fromCollectionAndArray(Collection<U> coll, U ... array) {
        if (array == null) {
            array = Sequence.nullSingletonArray();
        }
        if (coll == null && array == null) {
            return NullCollectionSequence.instance();
        }
        if (coll == null) {
            coll = new ArrayList<U>();
        } else if (array == null) {
            if (coll instanceof ICollectionSequence) {
                return (ICollectionSequence)coll;
            }
            final Collection<U> myColl = coll;
            return new CollectionSequence<U>(){

                @Override
                protected Collection<U> getCollection() {
                    return myColl;
                }
            };
        }
        List<U> input = Arrays.asList(array);
        coll.addAll(input);
        if (coll instanceof ICollectionSequence) {
            return (ICollectionSequence)coll;
        }
        final Collection<U> myColl = coll;
        return new CollectionSequence<U>(){

            @Override
            protected Collection<U> getCollection() {
                return myColl;
            }
        };
    }
}

