/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.internal.collections.runtime.impl;

import java.util.Iterator;
import java.util.NoSuchElementException;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internal.collections.runtime.impl.CardinalityMap;
import jetbrains.mps.internal.collections.runtime.impl.HasNextState;

public class LimitedCardinalitySequence<U>
extends Sequence<U> {
    private final Sequence<U> input;
    private final int maxCardinality;

    public LimitedCardinalitySequence(Sequence<U> input, int maxCardinality) {
        if (input == null) {
            throw new NullPointerException();
        }
        this.input = input;
        this.maxCardinality = maxCardinality;
    }

    @Override
    public Iterator<U> iterator() {
        return new LimitedCardinalityIterator();
    }

    private class LimitedCardinalityIterator
    implements Iterator<U> {
        private Iterator<U> inputIt;
        private CardinalityMap<U> cardMap;
        private U next;
        private HasNextState hasNext = HasNextState.UNKNOWN;

        @Override
        public boolean hasNext() {
            if (this.inputIt == null) {
                this.init();
            }
            if (this.hasNext.unknown()) {
                this.moveToNext();
            }
            return this.hasNext.hasNext();
        }

        @Override
        public U next() {
            if (this.inputIt == null) {
                this.init();
            }
            if (this.hasNext.unknown()) {
                this.moveToNext();
            }
            if (!this.hasNext.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.clearNext();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void moveToNext() {
            this.next = null;
            this.hasNext = HasNextState.AT_END;
            while (this.inputIt.hasNext()) {
                Object tmp = this.inputIt.next();
                if (this.cardMap.postInc(tmp) >= LimitedCardinalitySequence.this.maxCardinality) continue;
                this.next = tmp;
                this.hasNext = HasNextState.HAS_NEXT;
                return;
            }
            this.cardMap.clear();
        }

        private U clearNext() {
            Object tmp = this.next;
            this.next = null;
            this.hasNext = HasNextState.UNKNOWN;
            return tmp;
        }

        private void init() {
            this.inputIt = LimitedCardinalitySequence.this.input.iterator();
            this.cardMap = new CardinalityMap();
        }
    }
}

