/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.s3.model.BucketVersioningStatus;
import software.amazon.awssdk.services.s3.model.MFADeleteStatus;
import software.amazon.awssdk.services.s3.model.S3Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetBucketVersioningResponse
extends S3Response
implements ToCopyableBuilder<Builder, GetBucketVersioningResponse> {
    private final String status;
    private final String mfaDelete;

    private GetBucketVersioningResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.mfaDelete = builder.mfaDelete;
    }

    public BucketVersioningStatus status() {
        return BucketVersioningStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public MFADeleteStatus mfaDelete() {
        return MFADeleteStatus.fromValue(this.mfaDelete);
    }

    public String mfaDeleteAsString() {
        return this.mfaDelete;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.mfaDeleteAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBucketVersioningResponse)) {
            return false;
        }
        GetBucketVersioningResponse other = (GetBucketVersioningResponse)((Object)obj);
        return Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.mfaDeleteAsString(), other.mfaDeleteAsString());
    }

    public String toString() {
        return ToString.builder((String)"GetBucketVersioningResponse").add("Status", (Object)this.statusAsString()).add("MFADelete", (Object)this.mfaDeleteAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "MFADelete": {
                return Optional.ofNullable(clazz.cast(this.mfaDeleteAsString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends S3Response.BuilderImpl
    implements Builder {
        private String status;
        private String mfaDelete;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBucketVersioningResponse model) {
            super(model);
            this.status(model.status);
            this.mfaDelete(model.mfaDelete);
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(BucketVersioningStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getMFADelete() {
            return this.mfaDelete;
        }

        @Override
        public final Builder mfaDelete(String mfaDelete) {
            this.mfaDelete = mfaDelete;
            return this;
        }

        @Override
        public final Builder mfaDelete(MFADeleteStatus mfaDelete) {
            this.mfaDelete(mfaDelete.toString());
            return this;
        }

        public final void setMFADelete(String mfaDelete) {
            this.mfaDelete = mfaDelete;
        }

        @Override
        public GetBucketVersioningResponse build() {
            return new GetBucketVersioningResponse(this);
        }
    }

    public static interface Builder
    extends S3Response.Builder,
    CopyableBuilder<Builder, GetBucketVersioningResponse> {
        public Builder status(String var1);

        public Builder status(BucketVersioningStatus var1);

        public Builder mfaDelete(String var1);

        public Builder mfaDelete(MFADeleteStatus var1);
    }
}

