/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.s3.model.QueueConfiguration;
import software.amazon.awssdk.services.s3.transform.NotificationConfigurationFilterUnmarshaller;

public class QueueConfigurationUnmarshaller
implements Unmarshaller<QueueConfiguration, StaxUnmarshallerContext> {
    private static final QueueConfigurationUnmarshaller INSTANCE = new QueueConfigurationUnmarshaller();

    public QueueConfiguration unmarshall(StaxUnmarshallerContext context) throws Exception {
        QueueConfiguration.Builder queueConfiguration;
        block8: {
            queueConfiguration = QueueConfiguration.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<String> events = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    queueConfiguration.eventsWithStrings(events);
                    break block8;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("Id", targetDepth)) {
                        queueConfiguration.id(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Queue", targetDepth)) {
                        queueConfiguration.queueArn(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Event", targetDepth)) {
                        if (events == null) {
                            events = new ArrayList<String>();
                        }
                        events.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("Filter", targetDepth)) continue;
                    queueConfiguration.filter(NotificationConfigurationFilterUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            queueConfiguration.eventsWithStrings(events);
        }
        return (QueueConfiguration)queueConfiguration.build();
    }

    public static QueueConfigurationUnmarshaller getInstance() {
        return INSTANCE;
    }
}

