/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;

public abstract class AbstractTextElement
implements ExtensionElement {
    public static final String ELEMENT = "text";
    private final String text;
    private final String lang;

    protected AbstractTextElement(String text, String lang) {
        this.text = StringUtils.requireNotNullOrEmpty(text, "Text must not be null or empty");
        this.lang = lang;
    }

    @Override
    public String getElementName() {
        return ELEMENT;
    }

    @Override
    public XmlStringBuilder toXML(String enclosingNamespace) {
        XmlStringBuilder xml = new XmlStringBuilder(this);
        xml.optXmlLangAttribute(this.lang);
        xml.rightAngleBracket();
        xml.escape(this.text);
        xml.closeElement(this);
        return xml;
    }

    public final String getText() {
        return this.text;
    }

    public final String getLang() {
        return this.lang;
    }
}

