/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.crypto.convert;

import java.io.IOException;
import jetbrains.exodus.crypto.convert.EncryptListener;
import jetbrains.exodus.crypto.convert.FileHeader;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Ljetbrains/exodus/crypto/convert/ArchiveEncryptListenerFactory;", "Lmu/KLogging;", "()V", "newListener", "Ljetbrains/exodus/crypto/convert/EncryptListener;", "archive", "Lorg/apache/commons/compress/archivers/ArchiveOutputStream;", "xodus-crypto"})
public final class ArchiveEncryptListenerFactory
extends KLogging {
    public static final ArchiveEncryptListenerFactory INSTANCE;

    @NotNull
    public final EncryptListener newListener(@NotNull ArchiveOutputStream archive) {
        EncryptListener encryptListener;
        Intrinsics.checkParameterIsNotNull((Object)archive, (String)"archive");
        ArchiveOutputStream archiveOutputStream = archive;
        if (archiveOutputStream instanceof TarArchiveOutputStream) {
            encryptListener = new EncryptListener(archive){
                final /* synthetic */ ArchiveOutputStream $archive;

                public void onFile(@NotNull FileHeader header) {
                    Intrinsics.checkParameterIsNotNull((Object)header, (String)"header");
                    ArchiveEncryptListenerFactory.INSTANCE.getLogger().debug((Function0)new Function0<String>(header){
                        final /* synthetic */ FileHeader $header;

                        @NotNull
                        public final String invoke() {
                            return "Start file " + this.$header;
                        }
                        {
                            this.$header = fileHeader;
                            super(0);
                        }
                    });
                    TarArchiveEntry entry = new TarArchiveEntry(header.getPath() + header.getName());
                    entry.setSize(header.getSize());
                    entry.setModTime(header.getTimestamp());
                    this.$archive.putArchiveEntry((ArchiveEntry)entry);
                }

                public void onFileEnd(@NotNull FileHeader header) {
                    Intrinsics.checkParameterIsNotNull((Object)header, (String)"header");
                    this.$archive.closeArchiveEntry();
                }

                public void onData(@NotNull FileHeader header, int size, @NotNull byte[] data) {
                    Intrinsics.checkParameterIsNotNull((Object)header, (String)"header");
                    Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                    this.$archive.write(data, 0, size);
                }
                {
                    this.$archive = $captured_local_variable$0;
                }
            };
        } else if (archiveOutputStream instanceof ZipArchiveOutputStream) {
            encryptListener = new EncryptListener(archive){
                final /* synthetic */ ArchiveOutputStream $archive;

                public void onFile(@NotNull FileHeader header) {
                    Intrinsics.checkParameterIsNotNull((Object)header, (String)"header");
                    ArchiveEncryptListenerFactory.INSTANCE.getLogger().debug((Function0)new Function0<String>(header){
                        final /* synthetic */ FileHeader $header;

                        @NotNull
                        public final String invoke() {
                            return "Start file " + this.$header;
                        }
                        {
                            this.$header = fileHeader;
                            super(0);
                        }
                    });
                    ZipArchiveEntry entry = new ZipArchiveEntry(header.getPath() + header.getName());
                    entry.setSize(header.getSize());
                    entry.setTime(header.getTimestamp());
                    this.$archive.putArchiveEntry((ArchiveEntry)entry);
                }

                public void onFileEnd(@NotNull FileHeader header) {
                    Intrinsics.checkParameterIsNotNull((Object)header, (String)"header");
                    this.$archive.closeArchiveEntry();
                }

                public void onData(@NotNull FileHeader header, int size, @NotNull byte[] data) {
                    Intrinsics.checkParameterIsNotNull((Object)header, (String)"header");
                    Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                    this.$archive.write(data, 0, size);
                }
                {
                    this.$archive = $captured_local_variable$0;
                }
            };
        } else {
            throw (Throwable)new IOException("Unknown archive output stream");
        }
        return encryptListener;
    }

    private ArchiveEncryptListenerFactory() {
    }

    static {
        ArchiveEncryptListenerFactory archiveEncryptListenerFactory;
        INSTANCE = archiveEncryptListenerFactory = new ArchiveEncryptListenerFactory();
    }
}

