/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jetbrains.exodus.core.dataStructures.Pair;
import jetbrains.exodus.core.dataStructures.hash.HashMap;
import jetbrains.exodus.entitystore.EntityIterableType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Explainer {
    public static final String INSTANTIATED_FROM = "instantiated from";
    public static final String CURSOR_ADVANCES = "cursor advances";
    public static final String CURSOR_ADVANCES_BY_TYPE = "cursor advances by type";
    public static final String _CURSOR_ADVANCES_BY_TYPE = "#cursor advances by type";
    public static final String CURSOR_ADVANCES_BY_HANDLE = "cursor advances by handle";
    public static final String _CURSOR_ADVANCES_BY_HANDLE = "#cursor advances by handle";
    public static final String CURSOR_ADVANCES_FOR_FIRST = "cursor advances for first";
    public static final String AVERAGE_CURSOR_ADVANCES = "average cursor advances";
    public static final String ITERABLE_ADVANCES = "iterable advances";
    public static final String INITIAL_TREE = "initial tree";
    public static final String OPTIMIZED_TREE = "optimized tree";
    public static final String CONCURRENT_TRAVERSE_WARNING = "WARNING: concurrent traverse of single iterable";
    private static final String PACKAGE_TO_SKIP_IN_STACKTRACE = "jetbrains.teamsys.dnq.runtime.queries";
    private static final Logger logger = LoggerFactory.getLogger(Explainer.class);
    private final Map<Object, Map<String, Object>> queries = new ConcurrentHashMap<Object, Map<String, Object>>();
    private static final Collection<String> PERFORMANCE_PARAMETERS = new ArrayList<String>();
    private static final Map<String, Double> WORST_VALUES = new HashMap();
    private static Thread forceExplainThread = null;
    private boolean explainOn;

    public Explainer(boolean isExplainOn) {
        this.explainOn = isExplainOn;
    }

    public boolean isExplainOn() {
        return this.explainOn || Explainer.isExplainForcedForThread();
    }

    public Object genOrigin() {
        if (Explainer.isExplainForcedForThread()) {
            return Thread.currentThread();
        }
        if (this.explainOn) {
            return new Throwable();
        }
        return null;
    }

    public static void forceExplain(Thread thread) {
        forceExplainThread = thread;
    }

    public static boolean isExplainForcedForThread() {
        return Thread.currentThread() == forceExplainThread;
    }

    public void start(Object origin) {
        if (origin != null) {
            if (this.queries.get(origin) == null) {
                ConcurrentHashMap<String, String> map = new ConcurrentHashMap<String, String>();
                this.queries.put(origin, map);
                map.put(INSTANTIATED_FROM, "\nat " + Explainer.stripStackTrace(new Throwable()));
            } else {
                this.queries.get(origin).put(CONCURRENT_TRAVERSE_WARNING, "");
            }
        }
    }

    public void append(Object origin, String parameter, Object value) {
        Map<String, Object> query = this.queries.get(origin);
        if (query != null) {
            Object o = query.get(parameter);
            query.put(parameter, o == null ? value : o + ", " + value);
        }
    }

    public void explain(Object origin, String parameter, Object value) {
        Map<String, Object> query;
        if (origin != null && (query = this.queries.get(origin)) != null) {
            query.put(parameter, value);
        }
    }

    public void explain(Object origin, String parameter) {
        Map<String, Object> query;
        if (origin != null && (query = this.queries.get(origin)) != null) {
            Object value = query.get(parameter);
            if (value == null) {
                value = 0;
            }
            query.put(parameter, (Integer)value + 1);
            if (ITERABLE_ADVANCES.equals(parameter) && (Integer)query.get(ITERABLE_ADVANCES) == 1 && query.get(CURSOR_ADVANCES) != null) {
                query.put(CURSOR_ADVANCES_FOR_FIRST, query.get(CURSOR_ADVANCES));
            }
        }
    }

    public Map<String, Object> getParameters(Object origin) {
        return this.queries.get(origin);
    }

    public void log(Object origin) {
        boolean bl;
        if (origin == null) {
            return;
        }
        Map<String, Object> query = this.queries.get(origin);
        if (query == null || query.get(ITERABLE_ADVANCES) == null) {
            return;
        }
        Object cursorAdvances = query.get(CURSOR_ADVANCES);
        Object cursorAdvancesForFirst = query.get(CURSOR_ADVANCES_FOR_FIRST);
        if (cursorAdvances != null && cursorAdvancesForFirst != null) {
            query.put(AVERAGE_CURSOR_ADVANCES, (double)((Integer)cursorAdvances - (Integer)cursorAdvancesForFirst) * 1.0 / (double)((Integer)query.get(ITERABLE_ADVANCES)).intValue());
        }
        ArrayList<Pair> byType = new ArrayList<Pair>();
        ArrayList<Pair> byHandle = new ArrayList<Pair>();
        HashSet<String> toRemove = new HashSet<String>();
        for (String parameter : query.keySet()) {
            if (parameter.startsWith(_CURSOR_ADVANCES_BY_TYPE)) {
                toRemove.add(parameter);
                byType.add(new Pair((Object)((Integer)query.get(parameter)), (Object)EntityIterableType.valueOf(parameter.substring(_CURSOR_ADVANCES_BY_TYPE.length() + 1)).toString()));
            }
            if (!parameter.startsWith(_CURSOR_ADVANCES_BY_HANDLE)) continue;
            toRemove.add(parameter);
            byHandle.add(new Pair((Object)((Integer)query.get(parameter)), (Object)parameter.substring(_CURSOR_ADVANCES_BY_HANDLE.length() + 1)));
        }
        for (String parameter : toRemove) {
            query.remove(parameter);
        }
        Comparator<Pair<Integer, String>> pairComparator = new Comparator<Pair<Integer, String>>(){

            @Override
            public int compare(Pair<Integer, String> p1, Pair<Integer, String> p2) {
                return ((Integer)p2.getFirst()).compareTo((Integer)p1.getFirst());
            }
        };
        Collections.sort(byType, pairComparator);
        Collections.sort(byHandle, pairComparator);
        StringBuilder advancesByType = new StringBuilder();
        for (Pair pair : byType) {
            advancesByType.append('\n').append((String)pair.getSecond()).append(": ").append(pair.getFirst());
        }
        StringBuilder advancesByHandle = new StringBuilder();
        for (Pair pair : byHandle) {
            advancesByHandle.append('\n').append(pair.getFirst()).append(": ").append((String)pair.getSecond());
        }
        query.put(CURSOR_ADVANCES_BY_TYPE, advancesByType.toString());
        query.put(CURSOR_ADVANCES_BY_HANDLE, advancesByHandle.toString());
        boolean bl2 = false;
        for (String parameter : PERFORMANCE_PARAMETERS) {
            if (query.get(parameter) == null) continue;
            double value = ((Number)query.get(parameter)).doubleValue();
            Double worst = WORST_VALUES.get(parameter);
            if (!(worst <= value * 2.0)) continue;
            bl = true;
            WORST_VALUES.put(parameter, Math.max(value, worst));
        }
        if (bl) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Explain\n");
            for (Map.Entry<String, Object> entry : query.entrySet()) {
                stringBuilder.append(entry.getKey());
                stringBuilder.append(": ");
                stringBuilder.append(entry.getValue().toString());
                stringBuilder.append('\n');
            }
            logger.info(stringBuilder.toString());
        }
        if (!Explainer.isExplainForcedForThread()) {
            this.clean(origin);
        }
    }

    public void clean(Object origin) {
        if (origin != null) {
            this.queries.remove(origin);
        }
    }

    public static String stripStackTrace(Throwable throwable) {
        int i;
        StackTraceElement[] stackTrace = throwable.getStackTrace();
        for (i = 0; i < stackTrace.length && !stackTrace[i].getClassName().startsWith(PACKAGE_TO_SKIP_IN_STACKTRACE); ++i) {
        }
        while (i < stackTrace.length && stackTrace[i].getClassName().startsWith(PACKAGE_TO_SKIP_IN_STACKTRACE)) {
            ++i;
        }
        if (i >= stackTrace.length) {
            i = 0;
        }
        return stackTrace[i].toString();
    }

    static {
        PERFORMANCE_PARAMETERS.add(CURSOR_ADVANCES_FOR_FIRST);
        PERFORMANCE_PARAMETERS.add(AVERAGE_CURSOR_ADVANCES);
        for (String parameter : PERFORMANCE_PARAMETERS) {
            WORST_VALUES.put(parameter, (Double)Double.MIN_VALUE);
        }
    }
}

