/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.iterate;

import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityIterableHandle;
import jetbrains.exodus.entitystore.EntityIterableType;
import jetbrains.exodus.entitystore.PersistentEntityId;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.iterate.CachedInstanceIterable;
import jetbrains.exodus.entitystore.iterate.ConstantEntityIterableHandle;
import jetbrains.exodus.entitystore.iterate.EntityAddedOrDeletedHandleChecker;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableHandleBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableInstantiator;
import jetbrains.exodus.entitystore.iterate.EntityIteratorBase;
import jetbrains.exodus.entitystore.iterate.UpdatableEntityIdSortedSetCachedInstanceIterable;
import jetbrains.exodus.env.Cursor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntitiesOfTypeIterable
extends EntityIterableBase {
    private final int entityTypeId;

    public EntitiesOfTypeIterable(@NotNull PersistentStoreTransaction txn, int entityTypeId) {
        super(txn);
        this.entityTypeId = entityTypeId;
    }

    public static EntityIterableType getType() {
        return EntityIterableType.ALL_ENTITIES;
    }

    @Override
    public int getEntityTypeId() {
        return this.entityTypeId;
    }

    @Override
    @NotNull
    public EntityIteratorBase getIteratorImpl(@NotNull PersistentStoreTransaction txn) {
        return new EntitiesOfTypeIterator(this, this.getStore().getEntitiesIndexCursor(txn, this.entityTypeId));
    }

    @Override
    public boolean nonCachedHasFastCountAndIsEmpty() {
        return true;
    }

    @Override
    @NotNull
    protected EntityIterableHandle getHandleImpl() {
        return new EntitiesOfTypeIterableHandle(this);
    }

    @Override
    protected long countImpl(@NotNull PersistentStoreTransaction txn) {
        return this.getStore().getEntitiesTable(txn, this.entityTypeId).count(txn.getEnvironmentTransaction());
    }

    @Override
    public boolean isEmptyImpl(@NotNull PersistentStoreTransaction txn) {
        return this.countImpl(txn) == 0L;
    }

    @Override
    protected CachedInstanceIterable createCachedInstance(@NotNull PersistentStoreTransaction txn) {
        return new UpdatableEntityIdSortedSetCachedInstanceIterable(txn, this);
    }

    static {
        EntitiesOfTypeIterable.registerType(EntitiesOfTypeIterable.getType(), new EntityIterableInstantiator(){

            @Override
            public EntityIterableBase instantiate(PersistentStoreTransaction txn, PersistentEntityStoreImpl store, Object[] parameters) {
                return new EntitiesOfTypeIterable(txn, Integer.valueOf((String)parameters[0]));
            }
        });
    }

    public static class EntitiesOfTypeIterableHandle
    extends ConstantEntityIterableHandle {
        protected final int entityTypeId;

        public EntitiesOfTypeIterableHandle(@NotNull EntitiesOfTypeIterable source) {
            super(source.getStore(), EntitiesOfTypeIterable.getType());
            this.entityTypeId = source.entityTypeId;
        }

        @Override
        public void toString(@NotNull StringBuilder builder) {
            super.toString(builder);
            builder.append(this.entityTypeId);
        }

        @Override
        public void hashCode(@NotNull EntityIterableHandleBase.EntityIterableHandleHash hash) {
            hash.apply(this.entityTypeId);
        }

        @Override
        public int getEntityTypeId() {
            return this.entityTypeId;
        }

        @Override
        @NotNull
        public int[] getTypeIdsAffectingCreation() {
            return new int[]{this.entityTypeId};
        }

        @Override
        public boolean isMatchedEntityAdded(@NotNull EntityId added) {
            return added.getTypeId() == this.entityTypeId;
        }

        @Override
        public boolean isMatchedEntityDeleted(@NotNull EntityId deleted) {
            return deleted.getTypeId() == this.entityTypeId;
        }

        @Override
        public boolean onEntityAdded(@NotNull EntityAddedOrDeletedHandleChecker handleChecker) {
            UpdatableEntityIdSortedSetCachedInstanceIterable iterable = PersistentStoreTransaction.getUpdatable(handleChecker, this, UpdatableEntityIdSortedSetCachedInstanceIterable.class);
            if (iterable != null) {
                iterable.addEntity(handleChecker.getId());
                return true;
            }
            return false;
        }

        @Override
        public boolean onEntityDeleted(@NotNull EntityAddedOrDeletedHandleChecker handleChecker) {
            UpdatableEntityIdSortedSetCachedInstanceIterable iterable = PersistentStoreTransaction.getUpdatable(handleChecker, this, UpdatableEntityIdSortedSetCachedInstanceIterable.class);
            if (iterable != null) {
                iterable.removeEntity(handleChecker.getId());
                return true;
            }
            return false;
        }
    }

    public static final class EntitiesOfTypeIterator
    extends EntityIteratorBase {
        private boolean hasNext;
        private boolean hasNextValid;
        protected final int entityTypeId;

        public EntitiesOfTypeIterator(@NotNull EntitiesOfTypeIterable iterable, @NotNull Cursor index2) {
            super(iterable);
            this.entityTypeId = iterable.entityTypeId;
            this.setCursor(index2);
        }

        @Override
        public boolean hasNextImpl() {
            if (!this.hasNextValid) {
                this.hasNext = this.getCursor().getNext();
                this.hasNextValid = true;
            }
            return this.hasNext;
        }

        @Override
        @Nullable
        public EntityId nextIdImpl() {
            if (this.hasNextImpl()) {
                this.getIterable().explain(EntitiesOfTypeIterable.getType());
                EntityId result = this.getEntityId();
                this.hasNextValid = false;
                return result;
            }
            return null;
        }

        @Override
        @Nullable
        public EntityId getLast() {
            if (!this.getCursor().getPrev()) {
                return null;
            }
            return this.getEntityId();
        }

        private EntityId getEntityId() {
            return new PersistentEntityId(this.entityTypeId, LongBinding.compressedEntryToLong((ByteIterable)this.getCursor().getKey()));
        }
    }
}

