/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.iterate;

import jetbrains.exodus.core.dataStructures.IntArrayList;
import jetbrains.exodus.core.dataStructures.LongArrayList;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.iterate.CachedInstanceIterable;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.iterate.EntityIteratorBase;
import jetbrains.exodus.entitystore.iterate.OrderedEntityIdCollection;
import jetbrains.exodus.entitystore.iterate.cached.EmptyCachedInstanceIterable;
import jetbrains.exodus.entitystore.iterate.cached.MultiTypeSortedEntityIdArrayCachedInstanceIterable;
import jetbrains.exodus.entitystore.iterate.cached.MultiTypeUnsortedEntityIdArrayCachedInstanceIterable;
import jetbrains.exodus.entitystore.iterate.cached.SingleTypeSortedEntityIdArrayCachedInstanceIterable;
import jetbrains.exodus.entitystore.iterate.cached.SingleTypeSortedSetEntityIdCachedInstanceIterable;
import jetbrains.exodus.entitystore.iterate.cached.SingleTypeUnsortedEntityIdArrayCachedInstanceIterable;
import jetbrains.exodus.entitystore.util.ImmutableSingleTypeEntityIdBitSet;
import jetbrains.exodus.entitystore.util.ImmutableSingleTypeEntityIdCollection;
import jetbrains.exodus.entitystore.util.IntArrayListSpinAllocator;
import jetbrains.exodus.entitystore.util.LongArrayListSpinAllocator;
import org.jetbrains.annotations.NotNull;

public class EntityIdArrayCachedInstanceIterableFactory {
    public static final int MAX_COMPRESSED_SET_LOAD_FACTOR = 64;

    public static CachedInstanceIterable createInstance(@NotNull PersistentStoreTransaction txn, @NotNull EntityIterableBase source) {
        return EntityIdArrayCachedInstanceIterableFactory.createInstance(txn, source, (EntityIteratorBase)source.getIteratorImpl(txn));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CachedInstanceIterable createInstance(@NotNull PersistentStoreTransaction txn, @NotNull EntityIterableBase source, @NotNull EntityIteratorBase it) {
        try {
            LongArrayList localIds;
            IntArrayList typeIds;
            block44: {
                long max;
                long min;
                boolean onlyOneTypeId;
                block42: {
                    block43: {
                        CachedInstanceIterable cachedInstanceIterable;
                        if (!it.hasNext()) {
                            EmptyCachedInstanceIterable emptyCachedInstanceIterable = new EmptyCachedInstanceIterable(txn, source);
                            return emptyCachedInstanceIterable;
                        }
                        typeIds = IntArrayListSpinAllocator.alloc();
                        localIds = LongArrayListSpinAllocator.alloc();
                        try {
                            int lastTypeId;
                            onlyOneTypeId = true;
                            boolean localSorted = true;
                            if (source.isSortedById()) {
                                lastTypeId = -1;
                                EntityId id = it.nextId();
                                while (true) {
                                    int nextTypeId;
                                    if (id == null) {
                                        nextTypeId = Integer.MIN_VALUE;
                                        localIds.add(0L);
                                    } else {
                                        nextTypeId = id.getTypeId();
                                        localIds.add(id.getLocalId());
                                    }
                                    if (nextTypeId != lastTypeId) {
                                        if (lastTypeId != -1) {
                                            onlyOneTypeId = false;
                                            typeIds.add(localIds.size() - 1);
                                        }
                                        typeIds.add(nextTypeId);
                                        lastTypeId = nextTypeId;
                                    }
                                    if (!it.hasNext()) {
                                        if (onlyOneTypeId) break;
                                        typeIds.add(localIds.size());
                                        break;
                                    }
                                    id = it.nextId();
                                }
                                min = localIds.get(0);
                                max = localIds.get(localIds.size() - 1);
                            } else {
                                lastTypeId = -1;
                                long lastLocalId = -1L;
                                min = Long.MAX_VALUE;
                                max = Long.MIN_VALUE;
                                boolean compact = true;
                                EntityId id = it.nextId();
                                while (true) {
                                    long nextLocalId;
                                    int nextTypeId;
                                    if (id == null) {
                                        nextTypeId = Integer.MIN_VALUE;
                                        nextLocalId = 0L;
                                    } else {
                                        nextTypeId = id.getTypeId();
                                        nextLocalId = id.getLocalId();
                                    }
                                    if (localSorted) {
                                        if (lastTypeId > nextTypeId || lastTypeId == nextTypeId && lastLocalId > nextLocalId) {
                                            int length;
                                            if (nextTypeId == Integer.MIN_VALUE && (length = localIds.size()) <= 1) {
                                                if (length == 1) {
                                                    onlyOneTypeId = false;
                                                    localSorted = false;
                                                    compact = false;
                                                } else {
                                                    typeIds.add(Integer.MIN_VALUE);
                                                }
                                                lastLocalId = nextLocalId;
                                            } else {
                                                localSorted = false;
                                            }
                                        } else {
                                            lastLocalId = nextLocalId;
                                        }
                                    }
                                    localIds.add(nextLocalId);
                                    if (nextLocalId > max) {
                                        max = nextLocalId;
                                    }
                                    if (nextLocalId < min) {
                                        min = nextLocalId;
                                    }
                                    if (compact) {
                                        if (localSorted) {
                                            if (nextTypeId > lastTypeId) {
                                                if (lastTypeId != -1) {
                                                    onlyOneTypeId = false;
                                                    typeIds.add(localIds.size() - 1);
                                                }
                                                typeIds.add(nextTypeId);
                                            }
                                            lastTypeId = nextTypeId;
                                        } else if (typeIds.size() > 1 || nextTypeId != lastTypeId) {
                                            onlyOneTypeId = false;
                                            compact = false;
                                            EntityIdArrayCachedInstanceIterableFactory.addNextTypeId(nextTypeId, typeIds, localIds);
                                        }
                                    } else {
                                        typeIds.add(nextTypeId);
                                    }
                                    if (!it.hasNext()) {
                                        if (!compact || onlyOneTypeId) break;
                                        typeIds.add(localIds.size());
                                        break;
                                    }
                                    id = it.nextId();
                                }
                            }
                            if (!localSorted) break block42;
                            if (!onlyOneTypeId) break block43;
                            cachedInstanceIterable = EntityIdArrayCachedInstanceIterableFactory.makeSingleTypeSortedIterable(txn, source, it, typeIds, localIds, min, max);
                        }
                        catch (Throwable throwable) {
                            LongArrayListSpinAllocator.dispose(localIds);
                            IntArrayListSpinAllocator.dispose(typeIds);
                            throw throwable;
                        }
                        LongArrayListSpinAllocator.dispose(localIds);
                        IntArrayListSpinAllocator.dispose(typeIds);
                        return cachedInstanceIterable;
                    }
                    MultiTypeSortedEntityIdArrayCachedInstanceIterable multiTypeSortedEntityIdArrayCachedInstanceIterable = new MultiTypeSortedEntityIdArrayCachedInstanceIterable(txn, source, typeIds.toArray(), localIds.toArray(), it.toSet());
                    LongArrayListSpinAllocator.dispose(localIds);
                    IntArrayListSpinAllocator.dispose(typeIds);
                    return multiTypeSortedEntityIdArrayCachedInstanceIterable;
                }
                if (!onlyOneTypeId) break block44;
                CachedInstanceIterable cachedInstanceIterable = EntityIdArrayCachedInstanceIterableFactory.makeSingleTypeUnsortedIterable(txn, source, it, typeIds, localIds, min, max);
                LongArrayListSpinAllocator.dispose(localIds);
                IntArrayListSpinAllocator.dispose(typeIds);
                return cachedInstanceIterable;
            }
            MultiTypeUnsortedEntityIdArrayCachedInstanceIterable multiTypeUnsortedEntityIdArrayCachedInstanceIterable = new MultiTypeUnsortedEntityIdArrayCachedInstanceIterable(txn, source, typeIds.toArray(), localIds.toArray(), it.toSet());
            LongArrayListSpinAllocator.dispose(localIds);
            IntArrayListSpinAllocator.dispose(typeIds);
            return multiTypeUnsortedEntityIdArrayCachedInstanceIterable;
        }
        finally {
            it.disposeIfShouldBe();
        }
    }

    @NotNull
    private static CachedInstanceIterable makeSingleTypeSortedIterable(@NotNull PersistentStoreTransaction txn, @NotNull EntityIterableBase source, @NotNull EntityIteratorBase it, IntArrayList typeIds, LongArrayList localIds, long min, long max) {
        ImmutableSingleTypeEntityIdBitSet set;
        long range;
        int length;
        int typeId = typeIds.get(0);
        if (typeId != Integer.MIN_VALUE && (length = localIds.size()) > 1 && min >= 0L && (range = max - min + 1L) < Integer.MAX_VALUE && range <= 64L * (long)length && (set = new ImmutableSingleTypeEntityIdBitSet(typeId, localIds.getInstantArray(), length)).count() == length) {
            return new SingleTypeSortedSetEntityIdCachedInstanceIterable(txn, source, typeId, set);
        }
        return new SingleTypeSortedEntityIdArrayCachedInstanceIterable(txn, source, typeId, localIds.toArray(), it.toSet());
    }

    @NotNull
    private static CachedInstanceIterable makeSingleTypeUnsortedIterable(@NotNull PersistentStoreTransaction txn, @NotNull EntityIterableBase source, @NotNull EntityIteratorBase it, IntArrayList typeIds, LongArrayList localIds, long min, long max) {
        return new SingleTypeUnsortedEntityIdArrayCachedInstanceIterable(txn, source, typeIds.get(0), localIds.toArray(), it.toSet(), min, max);
    }

    @NotNull
    public static OrderedEntityIdCollection makeIdCollection(int typeId, long[] localIds) {
        long range;
        long min;
        int length = localIds.length;
        if (length > 1 && (min = localIds[0]) >= 0L && (range = localIds[length - 1] - min + 1L) < Integer.MAX_VALUE && range <= 64L * (long)length) {
            return new ImmutableSingleTypeEntityIdBitSet(typeId, localIds, length);
        }
        return new ImmutableSingleTypeEntityIdCollection(typeId, localIds);
    }

    private static void addNextTypeId(int nextTypeId, IntArrayList typeIds, LongArrayList localIds) {
        int[] typeIdsCopy = typeIds.toArray();
        int length = typeIds.size();
        int maxBound = localIds.size() - 1;
        typeIds.ensureCapacity(maxBound);
        typeIds.clear();
        int i = 0;
        int j = 0;
        int currentBound = 0;
        int typeId = 0;
        while (j < maxBound) {
            if (++j > currentBound) {
                typeId = typeIdsCopy[i];
                currentBound = ++i < length ? typeIdsCopy[i] : maxBound;
                ++i;
            }
            typeIds.add(typeId);
        }
        typeIds.add(nextTypeId);
    }
}

