/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.iterate;

import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.iterate.PropertiesIterable;
import jetbrains.exodus.env.Cursor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class PropertyRangeOrValueIterableBase
extends EntityIterableBase {
    private final int entityTypeId;
    private final int propertyId;
    private PropertiesIterable propertiesIterable;

    public PropertyRangeOrValueIterableBase(@Nullable PersistentStoreTransaction txn, int entityTypeId, int propertyId) {
        super(txn);
        this.entityTypeId = entityTypeId;
        this.propertyId = propertyId;
    }

    @Override
    public int getEntityTypeId() {
        return this.entityTypeId;
    }

    public int getPropertyId() {
        return this.propertyId;
    }

    @Override
    public boolean canBeCached() {
        return !this.getPropertiesIterable().isCached();
    }

    protected Cursor openCursor(@NotNull PersistentStoreTransaction txn) {
        return this.getStore().getPropertyValuesIndexCursor(txn, this.entityTypeId, this.propertyId);
    }

    protected EntityIterableBase getPropertyValueIndex() {
        return this.getStore().getEntityIterableCache().putIfNotCached(this.getPropertiesIterable());
    }

    private PropertiesIterable getPropertiesIterable() {
        if (this.propertiesIterable == null) {
            this.propertiesIterable = new PropertiesIterable(this.getTransaction(), this.entityTypeId, this.propertyId);
        }
        return this.propertiesIterable;
    }
}

