/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.iterate.cached;

import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.iterate.CachedInstanceIterable;
import jetbrains.exodus.entitystore.iterate.EntityIdSet;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.iterate.EntityIteratorBase;
import jetbrains.exodus.entitystore.iterate.cached.iterator.EntityIdArrayIteratorMultiTypeIdUnpacked;
import jetbrains.exodus.entitystore.iterate.cached.iterator.ReverseEntityIdArrayIteratorMultiTypeIdUnpacked;
import jetbrains.exodus.entitystore.util.EntityIdSetFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MultiTypeUnsortedEntityIdArrayCachedInstanceIterable
extends CachedInstanceIterable {
    private final int[] typeIds;
    private final long[] localIds;
    @Nullable
    private EntityIdSet idSet;

    public MultiTypeUnsortedEntityIdArrayCachedInstanceIterable(@NotNull PersistentStoreTransaction txn, @NotNull EntityIterableBase source, int[] typeIds, long[] localIds, @Nullable EntityIdSet idSet2) {
        super(txn, source);
        this.typeIds = typeIds;
        this.localIds = localIds;
        this.idSet = idSet2;
    }

    @Override
    protected CachedInstanceIterable orderById() {
        return this;
    }

    @Override
    public boolean isSortedById() {
        return false;
    }

    @Override
    protected long countImpl(@NotNull PersistentStoreTransaction txn) {
        return this.localIds.length;
    }

    @Override
    protected boolean containsImpl(@NotNull EntityId entityId) {
        EntityIdSet ids = this.idSet;
        if (ids != null) {
            return ids.contains(entityId);
        }
        return super.containsImpl(entityId);
    }

    @Override
    protected int indexOfImpl(@NotNull EntityId entityId) {
        long localId = entityId.getLocalId();
        int result = 0;
        do {
            if (this.localIds[result] != localId || this.typeIds[result] != entityId.getTypeId()) continue;
            return result;
        } while (++result < this.localIds.length);
        return -1;
    }

    @Override
    @NotNull
    public EntityIteratorBase getIteratorImpl(@NotNull PersistentStoreTransaction txn) {
        return new EntityIdArrayIteratorMultiTypeIdUnpacked(this, this.typeIds, this.localIds);
    }

    @Override
    @NotNull
    public EntityIteratorBase getReverseIteratorImpl(@NotNull PersistentStoreTransaction txn) {
        return new ReverseEntityIdArrayIteratorMultiTypeIdUnpacked(this, this.typeIds, this.localIds);
    }

    @Override
    @NotNull
    public EntityIdSet toSet(@NotNull PersistentStoreTransaction txn) {
        EntityIdSet result = this.idSet;
        if (result != null) {
            return result;
        }
        int count = this.typeIds.length;
        result = EntityIdSetFactory.newSet();
        for (int i = 0; i < count; ++i) {
            int typeId = this.typeIds[i];
            result = typeId == Integer.MIN_VALUE ? result.add(null) : result.add(typeId, this.localIds[i]);
        }
        this.idSet = result;
        return result;
    }
}

