/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.util;

import java.util.Iterator;
import java.util.Map;
import jetbrains.exodus.core.dataStructures.hash.IntHashMap;
import jetbrains.exodus.core.dataStructures.hash.LongHashSet;
import jetbrains.exodus.core.dataStructures.hash.LongIterator;
import jetbrains.exodus.core.dataStructures.hash.LongSet;
import jetbrains.exodus.core.dataStructures.hash.PackedLongHashSet;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.PersistentEntityId;
import jetbrains.exodus.entitystore.iterate.EntityIdSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MultiTypeEntityIdSet
implements EntityIdSet {
    @NotNull
    private final IntHashMap<LongSet> set = new IntHashMap();
    private boolean holdsNull;

    MultiTypeEntityIdSet(int typeId0, @NotNull LongSet singleTypeLocalIds0, int typeId1, @NotNull LongSet singleTypeLocalIds1, boolean holdsNull) {
        this.holdsNull = holdsNull;
        this.set.put(typeId0, (Object)singleTypeLocalIds0);
        this.set.put(typeId1, (Object)singleTypeLocalIds1);
    }

    public EntityIdSet add(@Nullable EntityId id) {
        if (id == null) {
            this.holdsNull = true;
            return this;
        }
        int typeId = id.getTypeId();
        long localId = id.getLocalId();
        return this.add(typeId, localId);
    }

    public EntityIdSet add(int typeId, long localId) {
        LongSet localIds = (LongSet)this.set.get(typeId);
        if (localIds == null) {
            localIds = new PackedLongHashSet();
            this.set.put(typeId, (Object)localIds);
        }
        localIds.add(localId);
        return this;
    }

    public boolean contains(@Nullable EntityId id) {
        if (id == null) {
            return this.holdsNull;
        }
        return this.contains(id.getTypeId(), id.getLocalId());
    }

    public boolean contains(int typeId, long localId) {
        LongSet localIds = (LongSet)this.set.get(typeId);
        return localIds != null && localIds.contains(localId);
    }

    public boolean remove(@Nullable EntityId id) {
        if (id == null) {
            boolean result = this.holdsNull;
            this.holdsNull = false;
            return result;
        }
        return this.remove(id.getTypeId(), id.getLocalId());
    }

    public boolean remove(int typeId, long localId) {
        LongSet localIds = (LongSet)this.set.get(typeId);
        return localIds != null && localIds.remove(localId);
    }

    public int count() {
        return -1;
    }

    @NotNull
    public LongSet getTypeSetSnapshot(int typeId) {
        LongSet typeSet = (LongSet)this.set.get(typeId);
        if (typeSet != null) {
            return new LongHashSet(typeSet);
        }
        return LongSet.EMPTY;
    }

    public Iterator<EntityId> iterator() {
        final Iterator entries = this.set.entrySet().iterator();
        return new Iterator<EntityId>(){
            private int typeId = -1;
            @NotNull
            private LongIterator it = LongIterator.EMPTY;
            private boolean hasNull = MultiTypeEntityIdSet.access$000(MultiTypeEntityIdSet.this);

            @Override
            public boolean hasNext() {
                while (!this.it.hasNext()) {
                    if (!entries.hasNext()) {
                        return this.hasNull;
                    }
                    Map.Entry nextTypeSet = (Map.Entry)entries.next();
                    this.typeId = (Integer)nextTypeSet.getKey();
                    this.it = ((LongSet)nextTypeSet.getValue()).iterator();
                }
                return true;
            }

            @Override
            public EntityId next() {
                if (!this.it.hasNext()) {
                    if (!this.hasNull) {
                        throw new IllegalStateException();
                    }
                    this.hasNull = false;
                    return null;
                }
                return new PersistentEntityId(this.typeId, (Long)this.it.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    static /* synthetic */ boolean access$000(MultiTypeEntityIdSet x0) {
        return x0.holdsNull;
    }
}

