/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.env;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.bindings.StringBinding;
import jetbrains.exodus.core.dataStructures.Pair;
import jetbrains.exodus.crypto.InvalidCipherParametersException;
import jetbrains.exodus.env.DatabaseRoot;
import jetbrains.exodus.env.EnvironmentImpl;
import jetbrains.exodus.env.MetaTree;
import jetbrains.exodus.env.MetaTreePrototype;
import jetbrains.exodus.log.CompressedUnsignedLongByteIterable;
import jetbrains.exodus.log.DataIterator;
import jetbrains.exodus.log.ExpiredLoggableInfo;
import jetbrains.exodus.log.Log;
import jetbrains.exodus.log.LogTip;
import jetbrains.exodus.log.LogUtil;
import jetbrains.exodus.log.Loggable;
import jetbrains.exodus.tree.ITree;
import jetbrains.exodus.tree.ITreeCursor;
import jetbrains.exodus.tree.ITreeMutable;
import jetbrains.exodus.tree.LongIterator;
import jetbrains.exodus.tree.TreeMetaInfo;
import jetbrains.exodus.tree.btree.BTree;
import jetbrains.exodus.tree.btree.BTreeEmpty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class MetaTreeImpl
implements MetaTree {
    private static final int EMPTY_LOG_BOUND = 5;
    final ITree tree;
    final long root;
    final LogTip logTip;

    MetaTreeImpl(ITree tree, long root, LogTip logTip) {
        this.tree = tree;
        this.root = root;
        this.logTip = logTip;
    }

    static Pair<MetaTreeImpl, Integer> create(@NotNull EnvironmentImpl env) {
        LogTip createdTip;
        long root;
        Log log = env.getLog();
        LogTip logTip = log.getTip();
        if (logTip.highAddress > 5L) {
            Loggable rootLoggable = log.getLastLoggableOfType(1);
            while (rootLoggable != null) {
                long root2 = rootLoggable.getAddress();
                DatabaseRoot dbRoot = null;
                try {
                    dbRoot = new DatabaseRoot(rootLoggable);
                }
                catch (ExodusException e) {
                    EnvironmentImpl.loggerError("Failed to load database root at " + rootLoggable.getAddress(), e);
                }
                if (dbRoot != null && dbRoot.isValid()) {
                    try {
                        LogTip updatedTip = log.setHighAddress(logTip, root2 + dbRoot.length());
                        BTree metaTree = env.loadMetaTree(dbRoot.getRootAddress(), updatedTip);
                        if (metaTree != null) {
                            MetaTreeImpl.cloneTree(metaTree);
                            log.sync();
                            return new Pair((Object)new MetaTreeImpl(metaTree, root2, updatedTip), (Object)dbRoot.getLastStructureId());
                        }
                        logTip = updatedTip;
                    }
                    catch (ExodusException e) {
                        logTip = log.getTip();
                        EnvironmentImpl.loggerError("Failed to recover to valid root" + LogUtil.getWrongAddressErrorMessage(dbRoot.getAddress(), env.getEnvironmentConfig().getLogFileSize() * 1024L), e);
                    }
                }
                rootLoggable = log.getLastLoggableOfTypeBefore(1, root2, logTip);
            }
            log.close();
            throw new InvalidCipherParametersException();
        }
        EnvironmentImpl.loggerInfo("No roots found: the database is empty");
        logTip = log.setHighAddress(logTip, 0L);
        ITree resultTree = MetaTreeImpl.getEmptyMetaTree(env);
        log.beginWrite();
        try {
            long rootAddress = resultTree.getMutableCopy().save();
            root = log.write((byte)1, 0, DatabaseRoot.asByteIterable(rootAddress, 1));
            log.flush();
            createdTip = log.endWrite();
        }
        catch (Throwable t) {
            log.revertWrite(logTip);
            throw new ExodusException("Can't init meta tree in log", t);
        }
        return new Pair((Object)new MetaTreeImpl(resultTree, root, createdTip), (Object)1);
    }

    static MetaTreeImpl create(@NotNull EnvironmentImpl env, @NotNull LogTip logTip, @NotNull MetaTreePrototype prototype) {
        return new MetaTreeImpl(env.loadMetaTree(prototype.treeAddress(), logTip), prototype.rootAddress(), logTip);
    }

    @Override
    public LogTip getLogTip() {
        return this.logTip;
    }

    @Override
    public long treeAddress() {
        return this.tree.getRootAddress();
    }

    @Override
    public long rootAddress() {
        return this.root;
    }

    LongIterator addressIterator() {
        return this.tree.addressIterator();
    }

    @Nullable
    TreeMetaInfo getMetaInfo(@NotNull String storeName, @NotNull EnvironmentImpl env) {
        ByteIterable value = this.tree.get((ByteIterable)StringBinding.stringToEntry((String)storeName));
        if (value == null) {
            return null;
        }
        return TreeMetaInfo.load(env, value);
    }

    long getRootAddress(int structureId) {
        ByteIterable value = this.tree.get((ByteIterable)LongBinding.longToCompressedEntry((long)structureId));
        return value == null ? -1L : CompressedUnsignedLongByteIterable.getLong(value);
    }

    static void removeStore(@NotNull ITreeMutable out, @NotNull String storeName, long id) {
        out.delete((ByteIterable)StringBinding.stringToEntry((String)storeName));
        out.delete((ByteIterable)LongBinding.longToCompressedEntry((long)id));
    }

    static void addStore(@NotNull ITreeMutable out, @NotNull String storeName, @NotNull TreeMetaInfo metaInfo) {
        out.put((ByteIterable)StringBinding.stringToEntry((String)storeName), metaInfo.toByteIterable());
    }

    static void saveTree(@NotNull ITreeMutable out, @NotNull ITreeMutable treeMutable) {
        long treeRootAddress = treeMutable.save();
        int structureId = treeMutable.getStructureId();
        out.put((ByteIterable)LongBinding.longToCompressedEntry((long)structureId), CompressedUnsignedLongByteIterable.getIterable(treeRootAddress));
    }

    @NotNull
    static Proto saveMetaTree(@NotNull ITreeMutable metaTree, @NotNull EnvironmentImpl env, @NotNull Collection<ExpiredLoggableInfo> expired) {
        long newMetaTreeAddress = metaTree.save();
        Log log = env.getLog();
        int lastStructureId = env.getLastStructureId();
        long dbRootAddress = log.write((byte)1, 0, DatabaseRoot.asByteIterable(newMetaTreeAddress, lastStructureId));
        expired.add(new ExpiredLoggableInfo(dbRootAddress, (int)(log.getWrittenHighAddress() - dbRootAddress)));
        return new Proto(newMetaTreeAddress, dbRootAddress);
    }

    long getAllStoreCount() {
        long size = this.tree.getSize();
        if (size % 2L != 0L) {
            EnvironmentImpl.loggerError("MetaTree size is not even");
        }
        return size / 2L;
    }

    @NotNull
    List<String> getAllStoreNames() {
        ITree tree = this.tree;
        if (tree.getSize() == 0L) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        ITreeCursor cursor = tree.openCursor();
        while (cursor.getNext()) {
            String storeName;
            ArrayByteIterable key = new ArrayByteIterable(cursor.getKey());
            if (!MetaTreeImpl.isStringKey(key) || EnvironmentImpl.isUtilizationProfile(storeName = StringBinding.entryToString((ByteIterable)key))) continue;
            result.add(storeName);
        }
        return result;
    }

    @Nullable
    String getStoreNameByStructureId(int structureId, @NotNull EnvironmentImpl env) {
        try (ITreeCursor cursor = this.tree.openCursor();){
            while (cursor.getNext()) {
                ByteIterable key = cursor.getKey();
                if (!MetaTreeImpl.isStringKey(new ArrayByteIterable(key)) || TreeMetaInfo.load(env, cursor.getValue()).getStructureId() != structureId) continue;
                String string = StringBinding.entryToString((ByteIterable)key);
                return string;
            }
        }
        return null;
    }

    MetaTreeImpl getClone() {
        return new MetaTreeImpl(MetaTreeImpl.cloneTree(this.tree), this.root, this.logTip);
    }

    static boolean isStringKey(ArrayByteIterable key) {
        return key.getBytesUnsafe()[key.getLength() - 1] == 0;
    }

    static ITreeMutable cloneTree(@NotNull ITree tree) {
        try (ITreeCursor cursor = tree.openCursor();){
            ITreeMutable result = tree.getMutableCopy();
            while (cursor.getNext()) {
                result.put(cursor.getKey(), cursor.getValue());
            }
            ITreeMutable iTreeMutable = result;
            return iTreeMutable;
        }
    }

    private static ITree getEmptyMetaTree(@NotNull EnvironmentImpl env) {
        return new BTreeEmpty(env.getLog(), env.getBTreeBalancePolicy(), false, 1){

            @Override
            @NotNull
            public DataIterator getDataIterator(long address) {
                return new DataIterator(this.log, address);
            }
        };
    }

    static class Proto
    implements MetaTreePrototype {
        final long address;
        final long root;

        Proto(long address, long root) {
            this.address = address;
            this.root = root;
        }

        @Override
        public long treeAddress() {
            return this.address;
        }

        @Override
        public long rootAddress() {
            return this.root;
        }
    }
}

