/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.gc;

import jetbrains.exodus.ExodusException;
import jetbrains.exodus.core.execution.DelegatingJobProcessor;
import jetbrains.exodus.core.execution.Job;
import jetbrains.exodus.core.execution.JobProcessorAdapter;
import jetbrains.exodus.core.execution.JobProcessorExceptionHandler;
import jetbrains.exodus.core.execution.LatchJob;
import jetbrains.exodus.core.execution.ThreadJobProcessor;
import jetbrains.exodus.core.execution.ThreadJobProcessorPool;
import jetbrains.exodus.env.EnvironmentConfig;
import jetbrains.exodus.gc.BackgroundCleaner;
import jetbrains.exodus.gc.BackgroundCleaningJob;
import jetbrains.exodus.gc.CleanEntireLogJob;
import jetbrains.exodus.gc.GarbageCollector;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\b\u0000\u0018\u0000  2\u00020\u0001:\u0001 B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\u0016J\u0006\u0010\u0018\u001a\u00020\u0016J\u0006\u0010\u0019\u001a\u00020\u0012J\u0006\u0010\u001a\u001a\u00020\u0016J\u000e\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u0014J\u0006\u0010\u001d\u001a\u00020\u0016J\u000e\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u001f\u001a\u00020\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\t\"\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\tR\u0011\u0010\r\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\tR$\u0010\u000f\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\t\"\u0004\b\u0010\u0010\u000bR\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Ljetbrains/exodus/gc/BackgroundCleaner;", "", "gc", "Ljetbrains/exodus/gc/GarbageCollector;", "(Ljetbrains/exodus/gc/GarbageCollector;)V", "backgroundCleaningJob", "Ljetbrains/exodus/gc/BackgroundCleaningJob;", "isCleaning", "", "()Z", "setCleaning", "(Z)V", "isCurrentThread", "isFinished", "<set-?>", "isSuspended", "setSuspended", "processor", "Ljetbrains/exodus/core/execution/JobProcessorAdapter;", "threadId", "", "checkThread", "", "cleanEntireLog", "finish", "getJobProcessor", "queueCleaningJob", "queueCleaningJobAt", "millis", "resume", "setJobProcessor", "suspend", "Companion", "xodus-environment"})
public final class BackgroundCleaner {
    private final BackgroundCleaningJob backgroundCleaningJob;
    private JobProcessorAdapter processor;
    private long threadId;
    private volatile boolean isSuspended;
    private volatile boolean isCleaning;
    private final GarbageCollector gc;
    public static final Companion Companion = new Companion(null);

    public final boolean isSuspended() {
        return this.isSuspended;
    }

    private final void setSuspended(boolean bl) {
        this.isSuspended = bl;
    }

    public final boolean isCleaning() {
        return this.isCleaning;
    }

    public final void setCleaning(boolean bl) {
        this.isCleaning = bl;
    }

    @NotNull
    public final JobProcessorAdapter setJobProcessor(@NotNull JobProcessorAdapter processor) {
        Intrinsics.checkParameterIsNotNull((Object)processor, (String)"processor");
        if (processor instanceof ThreadJobProcessor) {
            this.threadId = ((ThreadJobProcessor)processor).getId();
        } else if (processor instanceof DelegatingJobProcessor) {
            JobProcessorAdapter delegate = ((DelegatingJobProcessor)processor).getDelegate();
            if (delegate instanceof ThreadJobProcessor) {
                this.threadId = ((ThreadJobProcessor)delegate).getId();
            } else {
                throw (Throwable)new ExodusException("Unexpected job processor: " + processor);
            }
        }
        if (processor.getExceptionHandler() == null) {
            processor.setExceptionHandler((JobProcessorExceptionHandler)setJobProcessor.1.INSTANCE);
        }
        processor.start();
        this.processor = processor;
        return processor;
    }

    @NotNull
    public final JobProcessorAdapter getJobProcessor() {
        return this.processor;
    }

    public final boolean isFinished() {
        return this.processor.isFinished();
    }

    public final boolean isCurrentThread() {
        Thread thread = Thread.currentThread();
        Intrinsics.checkExpressionValueIsNotNull((Object)thread, (String)"Thread.currentThread()");
        return this.threadId == thread.getId();
    }

    public final void finish() {
        this.backgroundCleaningJob.cancel();
        this.processor.waitForLatchJob(new LatchJob(this){
            final /* synthetic */ BackgroundCleaner this$0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void execute() {
                try {
                    BackgroundCleaner.access$getGc$p(this.this$0).deletePendingFiles$xodus_environment();
                }
                finally {
                    this.release();
                }
            }
            {
                this.this$0 = $outer;
            }
        }, 100L);
        this.processor.finish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void suspend() {
        BackgroundCleaningJob $receiver$iv = this.backgroundCleaningJob;
        synchronized ($receiver$iv) {
            BackgroundCleaningJob $receiver = $receiver$iv;
            if (!this.isSuspended) {
                this.isSuspended = true;
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void resume() {
        BackgroundCleaningJob $receiver$iv = this.backgroundCleaningJob;
        synchronized ($receiver$iv) {
            BackgroundCleaningJob $receiver = $receiver$iv;
            this.isSuspended = false;
            Unit unit = Unit.INSTANCE;
        }
    }

    public final void queueCleaningJob() {
        EnvironmentConfig environmentConfig = this.gc.getEnvironment$xodus_environment().getEnvironmentConfig();
        Intrinsics.checkExpressionValueIsNotNull((Object)environmentConfig, (String)"gc.environment.environmentConfig");
        if (environmentConfig.isGcEnabled()) {
            this.processor.queue((Job)this.backgroundCleaningJob);
        }
    }

    public final void queueCleaningJobAt(long millis) {
        EnvironmentConfig environmentConfig = this.gc.getEnvironment$xodus_environment().getEnvironmentConfig();
        Intrinsics.checkExpressionValueIsNotNull((Object)environmentConfig, (String)"gc.environment.environmentConfig");
        if (environmentConfig.isGcEnabled()) {
            this.processor.queueAt((Job)this.backgroundCleaningJob, millis);
        }
    }

    public final void cleanEntireLog() {
        this.processor.waitForLatchJob((LatchJob)new CleanEntireLogJob(this.gc), 0L);
    }

    public final void checkThread() {
        if (!this.isCurrentThread()) {
            throw (Throwable)new ExodusException("Background cleaner thread expected as current one");
        }
    }

    public BackgroundCleaner(@NotNull GarbageCollector gc) {
        Intrinsics.checkParameterIsNotNull((Object)gc, (String)"gc");
        this.gc = gc;
        this.backgroundCleaningJob = new BackgroundCleaningJob(this.gc);
        EnvironmentConfig environmentConfig = this.gc.getEnvironment$xodus_environment().getEnvironmentConfig();
        Intrinsics.checkExpressionValueIsNotNull((Object)environmentConfig, (String)"gc.environment.environmentConfig");
        this.processor = this.setJobProcessor(environmentConfig.isLogCacheShared() ? (JobProcessorAdapter)new DelegatingJobProcessor((JobProcessorAdapter)ThreadJobProcessorPool.getOrCreateJobProcessor((String)"Exodus shared background cleaner")) : (JobProcessorAdapter)new ThreadJobProcessor("Exodus background cleaner for " + this.gc.getEnvironment$xodus_environment().getLocation()));
    }

    @NotNull
    public static final /* synthetic */ GarbageCollector access$getGc$p(BackgroundCleaner $this) {
        return $this.gc;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/exodus/gc/BackgroundCleaner$Companion;", "Lmu/KLogging;", "()V", "xodus-environment"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

