/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.Scanner;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.OutOfDiskSpaceException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LockingManager {
    private static final String LOCK_FILE_NAME = "xd.lck";
    @NotNull
    private final File dir;
    @Nullable
    private final String lockId;
    @Nullable
    private RandomAccessFile lockFile;
    @Nullable
    private FileLock lock;

    LockingManager(@NotNull File dir, @Nullable String lockId) {
        this.dir = dir;
        this.lockId = lockId;
    }

    public boolean lock(long timeout) {
        boolean result;
        long started = System.currentTimeMillis();
        while (!(result = this.lock())) {
            if (timeout > 0L) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
            if (System.currentTimeMillis() - started < timeout) continue;
        }
        return result;
    }

    public boolean release() {
        if (this.lockFile != null) {
            try {
                this.close();
                return true;
            }
            catch (IOException e) {
                throw new ExodusException("Failed to release lock file xd.lck", (Throwable)e);
            }
        }
        return false;
    }

    public long getUsableSpace() {
        return this.getLockFile().getUsableSpace();
    }

    private boolean lock() {
        if (this.lockFile != null) {
            return false;
        }
        try {
            RandomAccessFile lockFile;
            File lockFileHandle = this.getLockFile();
            this.lockFile = lockFile = new RandomAccessFile(lockFileHandle, "rw");
            FileChannel channel = lockFile.getChannel();
            this.lock = channel.tryLock();
            if (this.lock != null) {
                lockFile.setLength(0L);
                lockFile.writeBytes("Private property of Exodus:");
                if (this.lockId == null) {
                    RuntimeMXBean bean = ManagementFactory.getRuntimeMXBean();
                    if (bean != null) {
                        lockFile.writeBytes(' ' + bean.getName());
                    }
                } else {
                    lockFile.writeBytes(' ' + this.lockId);
                }
                lockFile.writeBytes("\n\n");
                for (StackTraceElement element : new Throwable().getStackTrace()) {
                    lockFile.writeBytes(element.toString() + '\n');
                }
                channel.force(false);
            }
        }
        catch (IOException e) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return this.throwFailedToLock(e);
        }
        catch (OverlappingFileLockException ofle) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.lock == null) {
            try {
                this.close();
            }
            catch (IOException e) {
                this.throwFailedToLock(e);
            }
        }
        return this.lockFile != null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String lockInfo() {
        try (FileInputStream lockStream = new FileInputStream(this.getLockFile());){
            Scanner scanner = new Scanner(lockStream).useDelimiter("\\A");
            String string = scanner.hasNext() ? scanner.next() : null;
            return string;
        }
        catch (IOException e) {
            throw new ExodusException("Failed to read contents of lock file xd.lck", (Throwable)e);
        }
    }

    @NotNull
    private File getLockFile() {
        return new File(this.dir, LOCK_FILE_NAME);
    }

    private boolean throwFailedToLock(@NotNull IOException e) {
        if (this.getUsableSpace() < 4096L) {
            throw new OutOfDiskSpaceException((Throwable)e);
        }
        throw new ExodusException("Failed to lock file xd.lck", (Throwable)e);
    }

    private void close() throws IOException {
        if (this.lock != null) {
            this.lock.release();
        }
        if (this.lockFile != null) {
            this.lockFile.close();
            this.lockFile = null;
        }
    }
}

