/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.io;

import com.sun.nio.file.SensitivityWatchEventModifier;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.List;
import java.util.concurrent.TimeUnit;
import jetbrains.exodus.env.EnvironmentImpl;
import jetbrains.exodus.env.UnsafeKt;
import jetbrains.exodus.io.Block;
import jetbrains.exodus.io.DataReader;
import jetbrains.exodus.io.FileDataReader;
import jetbrains.exodus.io.WatchingFileDataReader;
import jetbrains.exodus.log.LogUtil;
import jetbrains.exodus.system.JVMConstants;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u001d\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000bH\u0002J\b\u0010\u0016\u001a\u00020\u0012H\u0002J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0016J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u0014H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u0016\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \u000e*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Ljetbrains/exodus/io/WatchingFileDataReader;", "Ljetbrains/exodus/io/DataReader;", "envGetter", "Lkotlin/Function0;", "Ljetbrains/exodus/env/EnvironmentImpl;", "fileDataReader", "Ljetbrains/exodus/io/FileDataReader;", "(Lkotlin/jvm/functions/Function0;Ljetbrains/exodus/io/FileDataReader;)V", "getFileDataReader$xodus_environment", "()Ljetbrains/exodus/io/FileDataReader;", "stopped", "", "watchKey", "Ljava/nio/file/WatchKey;", "kotlin.jvm.PlatformType", "watchService", "Ljava/nio/file/WatchService;", "close", "", "doUpdate", "", "force", "doWatch", "getBlocks", "", "Ljetbrains/exodus/io/Block;", "fromAddress", "getLocation", "", "Companion", "xodus-environment"})
public final class WatchingFileDataReader
implements DataReader {
    private final WatchService watchService;
    private final WatchKey watchKey;
    private volatile boolean stopped;
    private final Function0<EnvironmentImpl> envGetter;
    @NotNull
    private final FileDataReader fileDataReader;
    private static final long IDLE_FORCE_CHECK_INTERVAL = 3000L;
    private static final long DEBOUNCE_INTERVAL = 100L;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getLocation() {
        return this.fileDataReader.getLocation();
    }

    @NotNull
    public Iterable<Block> getBlocks() {
        return this.fileDataReader.getBlocks();
    }

    @NotNull
    public Iterable<Block> getBlocks(long fromAddress) {
        return this.fileDataReader.getBlocks(fromAddress);
    }

    public void close() {
        this.stopped = true;
        this.watchKey.cancel();
        this.watchService.close();
        this.fileDataReader.close();
    }

    private final void doWatch() {
        long lastDirty = Long.MIN_VALUE;
        while (!this.stopped) {
            long debounce;
            WatchKey watchKey;
            boolean hasFileUpdates = false;
            try {
                List<WatchEvent<?>> events;
                WatchKey watchKey2 = watchKey = this.watchService.poll(45L, TimeUnit.MILLISECONDS);
                List<WatchEvent<Object>> list = events = watchKey2 != null ? watchKey2.pollEvents() : null;
                if (events == null || events.isEmpty()) {
                    if (lastDirty <= Long.MIN_VALUE || System.currentTimeMillis() - lastDirty <= 3000L) continue;
                    lastDirty = this.doUpdate(true);
                    continue;
                }
                for (WatchEvent<?> event : events) {
                    Object eventContext = event.context();
                    if (!(eventContext instanceof Path) || !LogUtil.LOG_FILE_NAME_FILTER.accept(null, ((Object)((Path)eventContext).getFileName()).toString())) continue;
                    hasFileUpdates = true;
                    break;
                }
            }
            catch (InterruptedException e) {
                Companion.getLogger().warn((Throwable)e, (Function0)doWatch.1.INSTANCE);
                Thread.currentThread().interrupt();
                return;
            }
            catch (ClosedWatchServiceException ignore) {
                return;
            }
            if (lastDirty > Long.MIN_VALUE && (debounce = 100L + (lastDirty - System.currentTimeMillis())) > (long)5) {
                try {
                    Thread.sleep(debounce);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
            if (hasFileUpdates) {
                lastDirty = this.doUpdate(false);
            }
            if (watchKey.reset()) continue;
            return;
        }
    }

    private final long doUpdate(boolean force) {
        EnvironmentImpl env = (EnvironmentImpl)this.envGetter.invoke();
        if (env != null) {
            if (UnsafeKt.tryUpdate(env)) {
                Companion.getLogger().info((Function0)new Function0<String>(force, env){
                    final /* synthetic */ boolean $force;
                    final /* synthetic */ EnvironmentImpl $env;

                    @NotNull
                    public final String invoke() {
                        return (this.$force ? "Env force-updated at " : "Env updated at ") + this.$env.getLocation();
                    }
                    {
                        this.$force = bl;
                        this.$env = environmentImpl;
                        super(0);
                    }
                });
                return Long.MIN_VALUE;
            }
            Companion.getLogger().info((Function0)new Function0<String>(force, env){
                final /* synthetic */ boolean $force;
                final /* synthetic */ EnvironmentImpl $env;

                @NotNull
                public final String invoke() {
                    return (this.$force ? "Can't force-update env at " : "Can't update env at ") + this.$env.getLocation();
                }
                {
                    this.$force = bl;
                    this.$env = environmentImpl;
                    super(0);
                }
            });
        }
        return System.currentTimeMillis();
    }

    @NotNull
    public final FileDataReader getFileDataReader$xodus_environment() {
        return this.fileDataReader;
    }

    public WatchingFileDataReader(@NotNull Function0<? extends EnvironmentImpl> envGetter, @NotNull FileDataReader fileDataReader) {
        WatchKey watchKey;
        Intrinsics.checkParameterIsNotNull(envGetter, (String)"envGetter");
        Intrinsics.checkParameterIsNotNull((Object)((Object)fileDataReader), (String)"fileDataReader");
        this.envGetter = envGetter;
        this.fileDataReader = fileDataReader;
        this.watchService = FileSystems.getDefault().newWatchService();
        Path path = this.fileDataReader.getDir().toPath();
        WatchingFileDataReader watchingFileDataReader = this;
        Path it = path;
        watchingFileDataReader.watchKey = watchKey = JVMConstants.INSTANCE.getIS_MAC() ? it.register(this.watchService, new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_MODIFY}, SensitivityWatchEventModifier.HIGH) : it.register(this.watchService, StandardWatchEventKinds.ENTRY_MODIFY);
        new Thread(new Runnable(){

            @Override
            public final void run() {
                this.doWatch();
            }
        }).start();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ljetbrains/exodus/io/WatchingFileDataReader$Companion;", "Lmu/KLogging;", "()V", "DEBOUNCE_INTERVAL", "", "IDLE_FORCE_CHECK_INTERVAL", "xodus-environment"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

