/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.log;

import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.ByteIterableBase;
import jetbrains.exodus.ByteIterator;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.log.DataIterator;
import jetbrains.exodus.util.LightOutputStream;
import org.jetbrains.annotations.NotNull;

public final class CompressedUnsignedLongByteIterable
extends ByteIterableBase {
    private static final int ITERABLES_CACHE_SIZE = 65536;
    private static final ByteIterable[] ITERABLES_CACHE = new ByteIterable[65536];
    private final long l;

    private CompressedUnsignedLongByteIterable(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException(String.valueOf(l));
        }
        this.l = l;
    }

    public static ByteIterable getIterable(long l) {
        if (l < 65536L) {
            return ITERABLES_CACHE[(int)l];
        }
        return new CompressedUnsignedLongByteIterable(l);
    }

    public static void fillBytes(long l, LightOutputStream output) {
        byte b;
        if (l < 0L) {
            throw new IllegalArgumentException(String.valueOf(l));
        }
        while (true) {
            b = (byte)(l & 0x7FL);
            if ((l >>= 7) == 0L) break;
            output.write((int)b);
        }
        output.write(b | 0x80);
    }

    public static long getLong(ByteIterable iterable) {
        return CompressedUnsignedLongByteIterable.getLong(iterable.iterator());
    }

    public static long getLong(ByteIterator iterator) {
        long result = 0L;
        int shift = 0;
        do {
            byte b = iterator.next();
            result += (long)(b & 0x7F) << shift;
            if ((b & 0x80) != 0) {
                return result;
            }
            shift += 7;
        } while (iterator.hasNext());
        return CompressedUnsignedLongByteIterable.throwBadCompressedNumber();
    }

    public static int getInt(ByteIterable iterable) {
        return CompressedUnsignedLongByteIterable.getInt(iterable.iterator());
    }

    public static int getInt(ByteIterator iterator) {
        int result = 0;
        int shift = 0;
        do {
            byte b = iterator.next();
            result += (b & 0x7F) << shift;
            if ((b & 0x80) != 0) {
                return result;
            }
            shift += 7;
        } while (iterator.hasNext());
        return CompressedUnsignedLongByteIterable.throwBadCompressedNumber();
    }

    public static int getInt(@NotNull DataIterator iterator) {
        byte b = iterator.next();
        if ((b & 0x80) != 0) {
            return b & 0x7F;
        }
        int result = b & 0x7F;
        int shift = 7;
        while (true) {
            b = iterator.next();
            result += (b & 0x7F) << shift;
            if ((b & 0x80) != 0) {
                return result;
            }
            shift += 7;
        }
    }

    public static int getCompressedSize(long l) {
        if (l < 128L) {
            return 1;
        }
        if (l < 16384L) {
            return 2;
        }
        l >>= 21;
        int result = 3;
        while (l > 0L) {
            ++result;
            l >>= 7;
        }
        return result;
    }

    protected ByteIterator getIterator() {
        return new ByteIterator(){
            private boolean goon = true;
            private long l = CompressedUnsignedLongByteIterable.access$000(CompressedUnsignedLongByteIterable.this);

            public boolean hasNext() {
                return this.goon;
            }

            public byte next() {
                byte b = (byte)(this.l & 0x7FL);
                this.l >>= 7;
                this.goon = this.l > 0L;
                if (!this.goon) {
                    b = (byte)(b | 0x80);
                }
                return b;
            }

            public long skip(long bytes) {
                for (long i2 = 0L; i2 < bytes; ++i2) {
                    if (this.goon) {
                        this.l >>= 7;
                    } else {
                        return i2;
                    }
                    this.goon = this.l > 0L;
                }
                return bytes;
            }
        };
    }

    private static int throwBadCompressedNumber() {
        throw new ExodusException("Bad compressed number");
    }

    static /* synthetic */ long access$000(CompressedUnsignedLongByteIterable x0) {
        return x0.l;
    }

    static {
        for (int i2 = 0; i2 < 65536; ++i2) {
            CompressedUnsignedLongByteIterable.ITERABLES_CACHE[i2] = new ArrayByteIterable((ByteIterable)new CompressedUnsignedLongByteIterable(i2));
        }
    }
}

