/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.lucene;

import java.io.IOException;
import jetbrains.exodus.env.Transaction;
import jetbrains.exodus.log.DataCorruptionException;
import jetbrains.exodus.lucene.ExodusDirectory;
import jetbrains.exodus.vfs.ClusteringStrategy;
import jetbrains.exodus.vfs.File;
import jetbrains.exodus.vfs.VfsConfig;
import jetbrains.exodus.vfs.VfsInputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.apache.lucene.store.BufferedIndexInput;
import org.apache.lucene.store.IndexInput;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0010\u0018\u00002\u00020\u0001:\u0001#B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0011\u001a\u00020\u0000H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\fH\u0002J\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\nH\u0016J \u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0007H\u0014J\u0010\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\nH\u0014J \u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001c\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\nH\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006$"}, d2={"Ljetbrains/exodus/lucene/ExodusIndexInput;", "Lorg/apache/lucene/store/BufferedIndexInput;", "directory", "Ljetbrains/exodus/lucene/ExodusDirectory;", "file", "Ljetbrains/exodus/vfs/File;", "bufferSize", "", "(Ljetbrains/exodus/lucene/ExodusDirectory;Ljetbrains/exodus/vfs/File;I)V", "currentPosition", "", "input", "Ljetbrains/exodus/vfs/VfsInputStream;", "txn", "Ljetbrains/exodus/env/Transaction;", "getTxn", "()Ljetbrains/exodus/env/Transaction;", "clone", "close", "", "getInput", "handleFalseDataCorruption", "e", "Ljetbrains/exodus/log/DataCorruptionException;", "length", "readInternal", "b", "", "offset", "seekInternal", "pos", "slice", "Lorg/apache/lucene/store/IndexInput;", "sliceDescription", "", "SlicedExodusIndexInput", "xodus-lucene-directory"})
public class ExodusIndexInput
extends BufferedIndexInput {
    private VfsInputStream input;
    private long currentPosition;
    private final ExodusDirectory directory;
    private final File file;

    public long length() {
        return this.directory.getVfs().getFileLength(this.getTxn(), this.file);
    }

    @NotNull
    public ExodusIndexInput clone() {
        ExodusIndexInput exodusIndexInput;
        long l;
        long it = l = this.getFilePointer();
        ExodusIndexInput $receiver = exodusIndexInput = new ExodusIndexInput(this.directory, this.file, this.getBufferSize());
        $receiver.seek(it);
        return exodusIndexInput;
    }

    public void close() {
        block0: {
            VfsInputStream vfsInputStream;
            VfsInputStream vfsInputStream2 = this.input;
            if (vfsInputStream2 == null) break block0;
            VfsInputStream $receiver = vfsInputStream = vfsInputStream2;
            $receiver.close();
            this.input = null;
        }
    }

    protected void readInternal(@NotNull byte[] b, int offset, int length) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)b, (String)"b");
        while (true) {
            try {
                this.currentPosition += (long)this.getInput().read(b, offset, length);
                return;
            }
            catch (DataCorruptionException e) {
                this.handleFalseDataCorruption(e);
                continue;
            }
            break;
        }
    }

    protected void seekInternal(long pos) throws IOException {
        if (pos != this.currentPosition) {
            VfsInputStream input = this.input;
            if (input == null) {
                this.currentPosition = pos;
                return;
            }
            if (pos > this.currentPosition) {
                VfsConfig vfsConfig = this.directory.getVfs().getConfig();
                Intrinsics.checkExpressionValueIsNotNull((Object)vfsConfig, (String)"directory.vfs.config");
                ClusteringStrategy clusteringStrategy = vfsConfig.getClusteringStrategy();
                long bytesToSkip = pos - this.currentPosition;
                ClusteringStrategy clusteringStrategy2 = clusteringStrategy;
                Intrinsics.checkExpressionValueIsNotNull((Object)clusteringStrategy2, (String)"clusteringStrategy");
                int clusterSize = clusteringStrategy2.getFirstClusterSize();
                if (!(clusteringStrategy.isLinear() && this.currentPosition % (long)clusterSize + bytesToSkip >= (long)clusterSize || input.skip(bytesToSkip) != bytesToSkip)) {
                    this.currentPosition = pos;
                    return;
                }
            }
            this.close();
            this.currentPosition = pos;
        }
    }

    @NotNull
    public IndexInput slice(@NotNull String sliceDescription, long offset, long length) {
        Intrinsics.checkParameterIsNotNull((Object)sliceDescription, (String)"sliceDescription");
        return (IndexInput)new SlicedExodusIndexInput(this, offset, length);
    }

    /*
     * WARNING - void declaration
     */
    private final VfsInputStream getInput() {
        VfsInputStream vfsInputStream;
        VfsInputStream vfsInputStream2 = this.input;
        VfsInputStream it = vfsInputStream2;
        if (it == null || it.isObsolete()) {
            VfsInputStream vfsInputStream3;
            VfsInputStream $receiver;
            this.input = $receiver = (vfsInputStream3 = this.directory.getVfs().readFile(this.getTxn(), this.file, this.currentPosition));
            VfsInputStream vfsInputStream4 = vfsInputStream3;
            vfsInputStream = vfsInputStream4;
            Intrinsics.checkExpressionValueIsNotNull((Object)vfsInputStream4, (String)"directory.vfs.readFile(t\u2026n).apply { input = this }");
        } else {
            void var2_2;
            vfsInputStream = var2_2;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)vfsInputStream, (String)"input.let {\n        if (\u2026       }\n        it\n    }");
        return vfsInputStream;
    }

    private final Transaction getTxn() {
        Transaction transaction = this.directory.getEnvironment().getAndCheckCurrentTransaction();
        Intrinsics.checkExpressionValueIsNotNull((Object)transaction, (String)"directory.environment.andCheckCurrentTransaction");
        return transaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handleFalseDataCorruption(DataCorruptionException e) {
        ExodusDirectory exodusDirectory = this.directory;
        synchronized (exodusDirectory) {
            VfsInputStream vfsInputStream = this.input;
            if (vfsInputStream == null || !vfsInputStream.isObsolete()) {
                throw (Throwable)e;
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    public ExodusIndexInput(@NotNull ExodusDirectory directory, @NotNull File file, int bufferSize) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)directory), (String)"directory");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        super("ExodusIndexInput[" + file.getPath() + ']', bufferSize);
        this.directory = directory;
        this.file = file;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\u0000H\u0016J\b\u0010\u0005\u001a\u00020\u0004H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0004H\u0014J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Ljetbrains/exodus/lucene/ExodusIndexInput$SlicedExodusIndexInput;", "Ljetbrains/exodus/lucene/ExodusIndexInput;", "base", "fileOffset", "", "length", "(Ljetbrains/exodus/lucene/ExodusIndexInput;JJ)V", "clone", "seekInternal", "", "pos", "slice", "Lorg/apache/lucene/store/IndexInput;", "sliceDescription", "", "offset", "xodus-lucene-directory"})
    private static final class SlicedExodusIndexInput
    extends ExodusIndexInput {
        private final ExodusIndexInput base;
        private final long fileOffset;
        private final long length;

        @Override
        public long length() {
            return this.length;
        }

        @Override
        @NotNull
        public SlicedExodusIndexInput clone() {
            SlicedExodusIndexInput slicedExodusIndexInput;
            long l;
            long it = l = this.getFilePointer();
            SlicedExodusIndexInput $receiver = slicedExodusIndexInput = new SlicedExodusIndexInput(this.base, this.fileOffset, this.length);
            $receiver.seek(it);
            return slicedExodusIndexInput;
        }

        @Override
        protected void seekInternal(long pos) {
            super.seekInternal(pos + this.fileOffset);
        }

        @Override
        @NotNull
        public IndexInput slice(@NotNull String sliceDescription, long offset, long length) {
            Intrinsics.checkParameterIsNotNull((Object)sliceDescription, (String)"sliceDescription");
            return this.base.slice(sliceDescription, this.fileOffset + offset, length);
        }

        public SlicedExodusIndexInput(@NotNull ExodusIndexInput base, long fileOffset, long length) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)base), (String)"base");
            long l = 1024;
            File file = base.file;
            ExodusDirectory exodusDirectory = base.directory;
            SlicedExodusIndexInput slicedExodusIndexInput = this;
            long l2 = Math.min(l, length);
            int n = (int)l2;
            int n2 = 8;
            int n3 = Math.max(n, n2);
            super(exodusDirectory, file, n3);
            this.base = base;
            this.fileOffset = fileOffset;
            this.length = length;
        }
    }
}

