/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.lucene;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import jetbrains.exodus.lucene.ExodusDirectory;
import jetbrains.exodus.vfs.File;
import jetbrains.exodus.vfs.VirtualFileSystem;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.lucene.store.BufferedChecksum;
import org.apache.lucene.store.IndexOutput;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\nH\u0016J\b\u0010\u0010\u001a\u00020\nH\u0016J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J \u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Ljetbrains/exodus/lucene/ExodusIndexOutput;", "Lorg/apache/lucene/store/IndexOutput;", "directory", "Ljetbrains/exodus/lucene/ExodusDirectory;", "name", "", "(Ljetbrains/exodus/lucene/ExodusDirectory;Ljava/lang/String;)V", "crc", "Lorg/apache/lucene/store/BufferedChecksum;", "currentPosition", "", "output", "Ljava/io/OutputStream;", "close", "", "getChecksum", "getFilePointer", "writeByte", "b", "", "writeBytes", "", "offset", "", "length", "xodus-lucene-directory"})
public final class ExodusIndexOutput
extends IndexOutput {
    private final OutputStream output;
    private long currentPosition;
    private final BufferedChecksum crc;

    public void close() throws IOException {
        this.output.close();
    }

    public long getFilePointer() {
        return this.currentPosition;
    }

    public long getChecksum() {
        return this.crc.getValue();
    }

    public void writeByte(byte b) throws IOException {
        this.output.write(b);
        ExodusIndexOutput exodusIndexOutput = this;
        ++exodusIndexOutput.currentPosition;
        long cfr_ignored_0 = exodusIndexOutput.currentPosition;
        this.crc.update((int)b);
    }

    public void writeBytes(@NotNull byte[] b, int offset, int length) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)b, (String)"b");
        if (length > 0) {
            if (length == 1) {
                this.writeByte(b[offset]);
            } else {
                this.output.write(b, offset, length);
                this.currentPosition += (long)length;
                this.crc.update(b, offset, length);
            }
        }
    }

    public ExodusIndexOutput(@NotNull ExodusDirectory directory, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)directory), (String)"directory");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        super("ExodusIndexOutput[" + name + ']', name);
        this.crc = new BufferedChecksum((Checksum)new CRC32());
        VirtualFileSystem vfs = directory.getVfs();
        File file = vfs.openFile(directory.getEnvironment().getAndCheckCurrentTransaction(), name, true);
        if (file == null) {
            throw (Throwable)new NullPointerException("Can't be");
        }
        File file2 = file;
        OutputStream outputStream = vfs.writeFile(directory.getEnvironment().getAndCheckCurrentTransaction(), file2);
        Intrinsics.checkExpressionValueIsNotNull((Object)outputStream, (String)"vfs.writeFile(directory.\u2026CurrentTransaction, file)");
        this.output = outputStream;
    }
}

