/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.lucene.codecs;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.lucene.codecs.compressing.Decompressor;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.util.BytesRef;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0000H\u0016J0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Ljetbrains/exodus/lucene/codecs/TrivialDecompressor;", "Lorg/apache/lucene/codecs/compressing/Decompressor;", "()V", "clone", "decompress", "", "input", "Lorg/apache/lucene/store/DataInput;", "originalLength", "", "offset", "length", "bytes", "Lorg/apache/lucene/util/BytesRef;", "xodus-lucene-directory"})
final class TrivialDecompressor
extends Decompressor {
    @NotNull
    public TrivialDecompressor clone() {
        return this;
    }

    public void decompress(@NotNull DataInput input, int originalLength, int offset, int length, @NotNull BytesRef bytes) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
        if (bytes.bytes.length < originalLength) {
            bytes.bytes = new byte[originalLength];
        }
        input.readBytes(bytes.bytes, 0, originalLength);
        bytes.offset = 0;
        bytes.length = originalLength;
    }
}

