/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.log.replication;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.io.Block;
import jetbrains.exodus.io.DataReader;
import jetbrains.exodus.log.Log;
import jetbrains.exodus.log.LogTip;
import jetbrains.exodus.log.replication.S3BlocksKt;
import jetbrains.exodus.log.replication.S3DataReader;
import jetbrains.exodus.log.replication.S3DataReaderOrWriter;
import jetbrains.exodus.log.replication.S3DataWriter;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0004\u0018\u0000 #2\u00020\u00012\u00020\u0002:\u0001#B)\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0015\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\b\u001eJ\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001b0 H\u0016J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001b0 2\u0006\u0010!\u001a\u00020\u001dH\u0016J\b\u0010\"\u001a\u00020\u0006H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006$"}, d2={"Ljetbrains/exodus/log/replication/S3DataReader;", "Ljetbrains/exodus/log/replication/S3DataReaderOrWriter;", "Ljetbrains/exodus/io/DataReader;", "s3", "Lsoftware/amazon/awssdk/services/s3/S3AsyncClient;", "bucket", "", "requestOverrideConfig", "Lsoftware/amazon/awssdk/awscore/AwsRequestOverrideConfiguration;", "writer", "Ljetbrains/exodus/log/replication/S3DataWriter;", "(Lsoftware/amazon/awssdk/services/s3/S3AsyncClient;Ljava/lang/String;Lsoftware/amazon/awssdk/awscore/AwsRequestOverrideConfiguration;Ljetbrains/exodus/log/replication/S3DataWriter;)V", "getBucket", "()Ljava/lang/String;", "logTip", "Ljetbrains/exodus/log/LogTip;", "getLogTip", "()Ljetbrains/exodus/log/LogTip;", "getRequestOverrideConfig", "()Lsoftware/amazon/awssdk/awscore/AwsRequestOverrideConfiguration;", "getS3", "()Lsoftware/amazon/awssdk/services/s3/S3AsyncClient;", "getWriter", "()Ljetbrains/exodus/log/replication/S3DataWriter;", "close", "", "getBlock", "Ljetbrains/exodus/io/Block;", "address", "", "getBlock$xodus_multinode", "getBlocks", "", "fromAddress", "getLocation", "Companion", "xodus-multinode"})
public final class S3DataReader
implements S3DataReaderOrWriter,
DataReader {
    @NotNull
    private final S3AsyncClient s3;
    @NotNull
    private final String bucket;
    @Nullable
    private final AwsRequestOverrideConfiguration requestOverrideConfig;
    @NotNull
    private final S3DataWriter writer;
    public static final Companion Companion = new Companion(null);

    @Override
    @Nullable
    public LogTip getLogTip() {
        return this.writer.getLogTip();
    }

    @NotNull
    public Iterable<Block> getBlocks() {
        Object object = this.getLogTip();
        if (object == null || (object = object.getCachedBlocks()) == null) {
            TreeSet treeSet;
            TreeSet $receiver = treeSet = new TreeSet(getBlocks.1.INSTANCE);
            $receiver.addAll(S3BlocksKt.getFileBlocks(this));
            $receiver.addAll(S3BlocksKt.getFolderBlocks(this));
            LogTip logTip = this.getLogTip();
            if (logTip != null) {
                logTip.setCachedBlocks((Iterable)$receiver);
            }
            object = treeSet;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Iterable<Block> getBlocks(long fromAddress) {
        void $receiver$iv$iv;
        Iterable<Block> $receiver$iv;
        Iterable<Block> iterable = $receiver$iv = this.getBlocks();
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Block it = (Block)element$iv$iv;
            if (!(it.getAddress() >= fromAddress)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public String getLocation() {
        return "s3:" + this.getBucket();
    }

    public void close() {
        this.getS3().close();
    }

    @NotNull
    public final Block getBlock$xodus_multinode(long address) {
        Block block;
        block2: {
            Iterable<Block> $receiver$iv = this.getBlocks();
            for (Block element$iv : $receiver$iv) {
                Block it = element$iv;
                if (!(it.getAddress() == address)) continue;
                block = element$iv;
                break block2;
            }
            block = null;
        }
        Block block2 = block;
        if (block2 == null) {
            throw (Throwable)new ExodusException("No block found by address " + address);
        }
        return block2;
    }

    @Override
    @NotNull
    public S3AsyncClient getS3() {
        return this.s3;
    }

    @Override
    @NotNull
    public String getBucket() {
        return this.bucket;
    }

    @Override
    @Nullable
    public AwsRequestOverrideConfiguration getRequestOverrideConfig() {
        return this.requestOverrideConfig;
    }

    @NotNull
    public final S3DataWriter getWriter() {
        return this.writer;
    }

    public S3DataReader(@NotNull S3AsyncClient s3, @NotNull String bucket, @Nullable AwsRequestOverrideConfiguration requestOverrideConfig, @NotNull S3DataWriter writer) {
        Intrinsics.checkParameterIsNotNull((Object)s3, (String)"s3");
        Intrinsics.checkParameterIsNotNull((Object)bucket, (String)"bucket");
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        this.s3 = s3;
        this.bucket = bucket;
        this.requestOverrideConfig = requestOverrideConfig;
        this.writer = writer;
    }

    public /* synthetic */ S3DataReader(S3AsyncClient s3AsyncClient, String string, AwsRequestOverrideConfiguration awsRequestOverrideConfiguration, S3DataWriter s3DataWriter, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            awsRequestOverrideConfiguration = null;
        }
        this(s3AsyncClient, string, awsRequestOverrideConfiguration, s3DataWriter);
    }

    @Override
    @NotNull
    public <T> CompletableFuture<T> getRemoteFile(long length, long startingLength, @NotNull String name, @NotNull AsyncResponseTransformer<GetObjectResponse, T> handler) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull(handler, (String)"handler");
        return S3DataReaderOrWriter.DefaultImpls.getRemoteFile(this, length, startingLength, name, handler);
    }

    @Override
    public boolean checkPreconditions(@NotNull Log log, long expectedLength, long startingLength) {
        Intrinsics.checkParameterIsNotNull((Object)log, (String)"log");
        return S3DataReaderOrWriter.DefaultImpls.checkPreconditions(this, log, expectedLength, startingLength);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/exodus/log/replication/S3DataReader$Companion;", "Lmu/KLogging;", "()V", "xodus-multinode"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

