/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.log.replication;

import jetbrains.exodus.core.dataStructures.Pair;
import jetbrains.exodus.env.Environment;
import jetbrains.exodus.env.EnvironmentImpl;
import jetbrains.exodus.io.DataReader;
import jetbrains.exodus.io.DataReaderWriterProvider;
import jetbrains.exodus.io.DataWriter;
import jetbrains.exodus.log.Log;
import jetbrains.exodus.log.replication.S3DataReader;
import jetbrains.exodus.log.replication.S3DataWriter;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.S3AsyncClientBuilder;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B#\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u001c\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u0014H\u0016R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Ljetbrains/exodus/log/replication/S3DataReaderWriterProvider;", "Ljetbrains/exodus/io/DataReaderWriterProvider;", "()V", "s3", "Lsoftware/amazon/awssdk/services/s3/S3AsyncClient;", "s3Sync", "Lsoftware/amazon/awssdk/services/s3/S3Client;", "requestOverrideConfig", "Lsoftware/amazon/awssdk/awscore/AwsRequestOverrideConfiguration;", "(Lsoftware/amazon/awssdk/services/s3/S3AsyncClient;Lsoftware/amazon/awssdk/services/s3/S3Client;Lsoftware/amazon/awssdk/awscore/AwsRequestOverrideConfiguration;)V", "env", "Ljetbrains/exodus/env/EnvironmentImpl;", "newReaderWriter", "Ljetbrains/exodus/core/dataStructures/Pair;", "Ljetbrains/exodus/io/DataReader;", "Ljetbrains/exodus/io/DataWriter;", "location", "", "onEnvironmentCreated", "", "Ljetbrains/exodus/env/Environment;", "xodus-multinode"})
public final class S3DataReaderWriterProvider
extends DataReaderWriterProvider {
    private EnvironmentImpl env;
    private final S3AsyncClient s3;
    private final S3Client s3Sync;
    private final AwsRequestOverrideConfiguration requestOverrideConfig;

    public void onEnvironmentCreated(@NotNull Environment env) {
        Intrinsics.checkParameterIsNotNull((Object)env, (String)"env");
        super.onEnvironmentCreated(env);
        this.env = (EnvironmentImpl)env;
    }

    @NotNull
    public Pair<DataReader, DataWriter> newReaderWriter(@NotNull String location) {
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        EnvironmentImpl environmentImpl = this.env;
        S3DataWriter writer = new S3DataWriter(this.s3Sync, this.s3, location, this.requestOverrideConfig, (Log)(environmentImpl != null ? environmentImpl.getLog() : null));
        return new Pair((Object)new S3DataReader(this.s3, location, this.requestOverrideConfig, writer), (Object)writer);
    }

    @JvmOverloads
    public S3DataReaderWriterProvider(@NotNull S3AsyncClient s3, @NotNull S3Client s3Sync, @Nullable AwsRequestOverrideConfiguration requestOverrideConfig) {
        Intrinsics.checkParameterIsNotNull((Object)s3, (String)"s3");
        Intrinsics.checkParameterIsNotNull((Object)s3Sync, (String)"s3Sync");
        this.s3 = s3;
        this.s3Sync = s3Sync;
        this.requestOverrideConfig = requestOverrideConfig;
    }

    @JvmOverloads
    public /* synthetic */ S3DataReaderWriterProvider(S3AsyncClient s3AsyncClient, S3Client s3Client, AwsRequestOverrideConfiguration awsRequestOverrideConfiguration, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            awsRequestOverrideConfiguration = null;
        }
        this(s3AsyncClient, s3Client, awsRequestOverrideConfiguration);
    }

    @JvmOverloads
    public S3DataReaderWriterProvider(@NotNull S3AsyncClient s3, @NotNull S3Client s3Sync) {
        this(s3, s3Sync, null, 4, null);
    }

    public S3DataReaderWriterProvider() {
        Object object = ((S3AsyncClientBuilder)S3AsyncClient.builder().region(Region.EU_WEST_1)).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"S3AsyncClient.builder().\u2026Region.EU_WEST_1).build()");
        S3AsyncClient s3AsyncClient = (S3AsyncClient)object;
        Object object2 = ((S3ClientBuilder)S3Client.builder().region(Region.EU_WEST_1)).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"S3Client.builder().regio\u2026Region.EU_WEST_1).build()");
        this(s3AsyncClient, (S3Client)object2, null, 4, null);
    }
}

