/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.log.replication;

import java.util.ArrayList;
import java.util.List;
import jetbrains.exodus.core.dataStructures.persistent.PersistentLongMap;
import jetbrains.exodus.log.replication.BasicS3Block;
import jetbrains.exodus.log.replication.S3DataReaderOrWriterKt;
import jetbrains.exodus.log.replication.S3FactoryBoilerplate;
import jetbrains.exodus.log.replication.S3FolderBlockKt;
import jetbrains.exodus.log.replication.S3SubBlock;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0096\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016J(\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u0016H\u0016J\b\u0010\u001d\u001a\u00020\u0000H\u0016R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001e"}, d2={"Ljetbrains/exodus/log/replication/S3FolderBlock;", "Ljetbrains/exodus/log/replication/BasicS3Block;", "s3factory", "Ljetbrains/exodus/log/replication/S3FactoryBoilerplate;", "address", "", "size", "blocks", "Ljetbrains/exodus/core/dataStructures/persistent/PersistentLongMap;", "Ljetbrains/exodus/log/replication/S3SubBlock;", "(Ljetbrains/exodus/log/replication/S3FactoryBoilerplate;JJLjetbrains/exodus/core/dataStructures/persistent/PersistentLongMap;)V", "getBlocks$xodus_multinode", "()Ljetbrains/exodus/core/dataStructures/persistent/PersistentLongMap;", "key", "", "getKey", "()Ljava/lang/String;", "equals", "", "other", "", "hashCode", "", "read", "output", "", "position", "offset", "count", "refresh", "xodus-multinode"})
public final class S3FolderBlock
extends BasicS3Block {
    @NotNull
    private final PersistentLongMap<S3SubBlock> blocks;

    @Override
    @NotNull
    public String getKey() {
        return S3DataReaderOrWriterKt.getPartialFolderPrefix(this.getAddr$xodus_multinode());
    }

    @Override
    public int read(@NotNull byte[] output, long position, int offset, int count) {
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        if (count <= 0) {
            return 0;
        }
        List blocks = new ArrayList();
        long leftBound = this.getAddress() + position;
        long rightBound = leftBound + (long)count;
        PersistentLongMap<S3SubBlock> $receiver$iv = this.blocks;
        PersistentLongMap.ImmutableMap immutableMap = $receiver$iv.beginRead();
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableMap, (String)"beginRead()");
        PersistentLongMap.ImmutableMap $receiver = immutableMap;
        Iterable $receiver$iv2 = (Iterable)$receiver;
        for (Object element$iv : $receiver$iv2) {
            PersistentLongMap.Entry it;
            PersistentLongMap.Entry entry = it = (PersistentLongMap.Entry)element$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)entry, (String)"it");
            Object object = entry.getValue();
            S3SubBlock $receiver2 = (S3SubBlock)object;
            if ($receiver2.getAddress() >= leftBound && $receiver2.getAddress() >= rightBound) continue;
            S3SubBlock s3SubBlock = $receiver2;
            Intrinsics.checkExpressionValueIsNotNull((Object)s3SubBlock, (String)"this");
            blocks.add(s3SubBlock);
        }
        int totalRead = 0;
        Iterable $receiver$iv3 = blocks;
        for (Object element$iv : $receiver$iv3) {
            int n;
            S3SubBlock block = (S3SubBlock)element$iv;
            long blockPosition = leftBound + (long)totalRead - block.getAddress();
            int bytesToRead = Math.min((int)(block.length() - blockPosition), count - totalRead);
            int it = n = block.readAndCompare$xodus_multinode(output, blockPosition, offset + totalRead, bytesToRead);
            totalRead += it;
        }
        return totalRead;
    }

    @Override
    @NotNull
    public S3FolderBlock refresh() {
        return S3FolderBlockKt.newS3FolderBlock(this.getS3factory$xodus_multinode(), this.getAddr$xodus_multinode());
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof S3FolderBlock)) {
            return false;
        }
        return this.getAddr$xodus_multinode() == ((S3FolderBlock)other).getAddr$xodus_multinode();
    }

    public int hashCode() {
        return Long.hashCode(this.getAddr$xodus_multinode());
    }

    @NotNull
    public final PersistentLongMap<S3SubBlock> getBlocks$xodus_multinode() {
        return this.blocks;
    }

    public S3FolderBlock(@NotNull S3FactoryBoilerplate s3factory, long address, long size, @NotNull PersistentLongMap<S3SubBlock> blocks) {
        Intrinsics.checkParameterIsNotNull((Object)s3factory, (String)"s3factory");
        Intrinsics.checkParameterIsNotNull(blocks, (String)"blocks");
        super(s3factory, address, size);
        this.blocks = blocks;
    }
}

