/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.bindings;

import java.io.ByteArrayInputStream;
import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.bindings.ComparableBinding;
import jetbrains.exodus.bindings.ComparableSet;
import jetbrains.exodus.bindings.ComparableValueType;
import jetbrains.exodus.util.LightOutputStream;
import org.jetbrains.annotations.NotNull;

public class ComparableSetBinding
extends ComparableBinding {
    public static final ComparableSetBinding BINDING = new ComparableSetBinding();

    private ComparableSetBinding() {
    }

    @Override
    public ComparableSet readObject(@NotNull ByteArrayInputStream stream) {
        int valueTypeId = stream.read() ^ 0x80;
        ComparableBinding itemBinding = ComparableValueType.getPredefinedBinding(valueTypeId);
        ComparableSet<Comparable> result = new ComparableSet<Comparable>();
        while (stream.available() > 0) {
            result.addItem(itemBinding.readObject(stream));
        }
        result.setIsDirty(false);
        return result;
    }

    @Override
    public void writeObject(final @NotNull LightOutputStream output, @NotNull Comparable object) {
        ComparableSet set = (ComparableSet)object;
        Class<Comparable> itemClass = set.getItemClass();
        if (itemClass == null) {
            throw new ExodusException("Attempt to write empty ComparableSet");
        }
        ComparableValueType type = ComparableValueType.getPredefinedType(itemClass);
        output.writeByte(type.getTypeId());
        final ComparableBinding itemBinding = type.getBinding();
        set.forEach(new ComparableSet.Consumer(){

            public void accept(@NotNull Comparable item, int index) {
                itemBinding.writeObject(output, item);
            }
        });
    }

    public static ComparableSet entryToComparableSet(@NotNull ByteIterable entry) {
        return (ComparableSet)BINDING.entryToObject(entry);
    }

    public static ArrayByteIterable comparableSetToEntry(@NotNull ComparableSet object) {
        return BINDING.objectToEntry(object);
    }
}

