/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.SortEngine;
import org.jetbrains.annotations.NotNull;

public class InMemoryTimSortIterable
extends SortEngine.InMemorySortIterable {
    private static final int MIN_RUN_LENGTH = 32;

    public InMemoryTimSortIterable(@NotNull Iterable<Entity> source, @NotNull Comparator<Entity> comparator) {
        super(source, comparator);
    }

    @Override
    public Iterator<Entity> iterator() {
        return new Iterator<Entity>(){
            private List<Entity> src;
            private int runCount;
            private int nodeCount;
            private int[] from;
            private int[] len;
            private int[] left;
            private int[] right;
            private int current;
            private int head;

            @Override
            public boolean hasNext() {
                if (this.src == null) {
                    this.init();
                }
                return this.current < this.src.size();
            }

            @Override
            public Entity next() {
                if (this.src == null) {
                    this.init();
                }
                if (this.current >= this.src.size()) {
                    throw new NoSuchElementException();
                }
                this.computeMinimum();
                int r = this.from[this.head];
                this.markAsUsed(r);
                ++this.current;
                return this.src.get(r);
            }

            private void computeMinimum() {
                ArrayList<Integer> stack = new ArrayList<Integer>();
                stack.add(this.head);
                while (this.from[this.head] < 0) {
                    int node = (Integer)stack.get(stack.size() - 1);
                    if (this.from[this.left[node]] < 0) {
                        stack.add(this.left[node]);
                        continue;
                    }
                    if (this.from[this.right[node]] < 0) {
                        stack.add(this.right[node]);
                        continue;
                    }
                    if (this.len[this.right[node]] <= 0 || this.len[this.left[node]] > 0 && InMemoryTimSortIterable.this.comparator.compare(this.src.get(this.from[this.left[node]]), this.src.get(this.from[this.right[node]])) <= 0) {
                        this.from[node] = this.from[this.left[node]];
                        int n = this.left[node];
                        this.len[n] = this.len[n] - 1;
                    } else {
                        this.from[node] = this.from[this.right[node]];
                        int n = this.right[node];
                        this.len[n] = this.len[n] - 1;
                    }
                    stack.remove(stack.size() - 1);
                }
            }

            private void markAsUsed(int r) {
                int i = this.head;
                while (this.left[i] >= 0) {
                    this.from[i] = -1;
                    if (this.from[this.left[i]] == r) {
                        i = this.left[i];
                        continue;
                    }
                    i = this.right[i];
                }
                int n = i;
                this.from[n] = this.from[n] + 1;
                if (this.len[i] <= 0) {
                    this.from[i] = this.src.size();
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            public void init() {
                int i;
                int minRunLength;
                this.src = new ArrayList<Entity>();
                for (Entity entity : InMemoryTimSortIterable.this.source) {
                    this.src.add(entity);
                }
                int n = this.src.size();
                if (n == 0) {
                    return;
                }
                int b = 0;
                for (minRunLength = n; minRunLength >= 32; minRunLength >>= 1) {
                    b |= minRunLength;
                }
                int maxRuns = 1 + (n + (minRunLength += b & 1) - 1) / minRunLength;
                this.from = new int[maxRuns * 2 - 1];
                this.len = new int[maxRuns * 2 - 1];
                this.left = new int[maxRuns * 2 - 1];
                Arrays.fill(this.left, -1);
                this.right = new int[maxRuns * 2 - 1];
                ArrayList<Integer> stack = new ArrayList<Integer>();
                this.runCount = 0;
                boolean growing = true;
                block2: for (i = 1; i < n; ++i) {
                    if (InMemoryTimSortIterable.this.comparator.compare(this.src.get(i - 1), this.src.get(i)) <= 0 == growing) continue;
                    if (i == this.from[this.runCount] + 1) {
                        growing = !growing;
                        continue;
                    }
                    if (!growing) {
                        this.reverse(i);
                    }
                    while (i < n && i - this.from[this.runCount] < minRunLength) {
                        int j;
                        Entity t = this.src.get(i);
                        for (j = i - 1; j >= this.from[this.runCount] && InMemoryTimSortIterable.this.comparator.compare(this.src.get(j), t) > 0; --j) {
                            this.src.set(j + 1, this.src.get(j));
                        }
                        this.src.set(j + 1, t);
                        ++i;
                    }
                    this.len[this.runCount] = i - this.from[this.runCount];
                    this.from[++this.runCount] = i;
                    stack.add(this.runCount - 1);
                    while (true) {
                        int s;
                        if ((s = stack.size()) >= 3 && this.len[stack.get(s - 3)] <= this.len[stack.get(s - 2)] + this.len[stack.get(s - 1)]) {
                            if (this.len[stack.get(s - 3)] < this.len[stack.get(s - 1)]) {
                                this.unite(stack, s - 3, maxRuns);
                                continue;
                            }
                            this.unite(stack, s - 2, maxRuns);
                            continue;
                        }
                        if (s < 2 || this.len[stack.get(s - 2)] > this.len[stack.get(s - 1)]) continue block2;
                        this.unite(stack, s - 2, maxRuns);
                    }
                }
                this.len[this.runCount] = n - this.from[this.runCount];
                if (this.len[this.runCount] > 0) {
                    if (!growing) {
                        this.reverse(n);
                    }
                    stack.add(this.runCount);
                    ++this.runCount;
                }
                for (i = stack.size() - 2; i >= 0; --i) {
                    if (i > 0 && this.len[stack.get(i - 1)] < this.len[stack.get(i + 1)]) {
                        this.unite(stack, i - 1, maxRuns);
                        continue;
                    }
                    this.unite(stack, i, maxRuns);
                }
                for (i = 0; i < this.nodeCount; ++i) {
                    this.from[i + maxRuns] = -1;
                }
                this.head = stack.get(0);
            }

            private void reverse(int to) {
                int l = this.from[this.runCount];
                for (int r = to - 1; l < r; ++l, --r) {
                    Entity t = this.src.get(l);
                    this.src.set(l, this.src.get(r));
                    this.src.set(r, t);
                }
            }

            private void unite(ArrayList<Integer> stack, int p, int shift) {
                int node = this.nodeCount + shift;
                this.from[node] = this.from[stack.get(p)];
                this.len[node] = this.len[stack.get(p)] + this.len[stack.get(p + 1)];
                this.left[node] = stack.get(p);
                this.right[node] = stack.get(p + 1);
                stack.set(p, node);
                ++this.nodeCount;
                stack.remove(p + 1);
            }
        };
    }
}

