/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.query;

import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityIterable;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.query.LinkEqual;
import jetbrains.exodus.query.LinkNotNull;
import jetbrains.exodus.query.Minus;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.NodeFactory;
import jetbrains.exodus.query.OptimizationPlan;
import jetbrains.exodus.query.PropertyEqual;
import jetbrains.exodus.query.PropertyNotNull;
import jetbrains.exodus.query.QueryEngine;
import jetbrains.exodus.query.Sorts;
import jetbrains.exodus.query.Utils;
import jetbrains.exodus.query.metadata.EntityMetaData;
import jetbrains.exodus.query.metadata.ModelMetaData;

public class LinksEqualDecorator
extends NodeBase {
    private final String name;
    private NodeBase decorated;
    private final String decoratedEntityType;

    public LinksEqualDecorator(String name, NodeBase decorated, String decoratedEntityType) {
        this.name = name;
        this.decorated = decorated;
        this.decoratedEntityType = decoratedEntityType;
    }

    @Override
    public Iterable<Entity> instantiate(String entityType, QueryEngine queryEngine, ModelMetaData metaData) {
        queryEngine.assertOperational();
        return queryEngine.getPersistentStore().getAndCheckCurrentTransaction().findLinks(entityType, (EntityIterable)this.instantiateDecorated(this.decoratedEntityType, queryEngine, metaData), this.name);
    }

    @Override
    public NodeBase getClone() {
        return new LinksEqualDecorator(this.name, this.decorated.getClone(), this.decoratedEntityType);
    }

    public NodeBase getDecorated() {
        return this.decorated;
    }

    public void setDecorated(NodeBase decorated) {
        this.decorated = decorated;
    }

    protected Iterable<Entity> instantiateDecorated(String entityType, QueryEngine queryEngine, ModelMetaData metaData) {
        Object result;
        EntityMetaData emd = metaData == null ? null : metaData.getEntityMetaData(entityType);
        Object object = result = emd != null && emd.isAbstract() ? EntityIterableBase.EMPTY : this.decorated.instantiate(entityType, queryEngine, metaData);
        if (emd != null) {
            for (String subType : emd.getSubTypes()) {
                result = queryEngine.unionAdjusted((Iterable<Entity>)result, this.instantiateDecorated(subType, queryEngine, metaData));
            }
        }
        return result;
    }

    @Override
    public void optimize(Sorts sorts, OptimizationPlan rules) {
        PropertyEqual propEqual;
        if (this.decorated instanceof LinkEqual) {
            LinkEqual linkEqual = (LinkEqual)this.decorated;
            if (linkEqual.getToId() == null) {
                this.setDecorated(new Minus(NodeFactory.all(), new LinkNotNull(linkEqual.getName())));
            }
        } else if (this.decorated instanceof PropertyEqual && (propEqual = (PropertyEqual)this.decorated).getValue() == null) {
            this.setDecorated(new Minus(NodeFactory.all(), new PropertyNotNull(propEqual.getName())));
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        this.checkWildcard(obj);
        if (!(obj instanceof LinksEqualDecorator)) {
            return false;
        }
        LinksEqualDecorator decorator = (LinksEqualDecorator)obj;
        if (!Utils.safe_equals(this.name, decorator.name) || !Utils.safe_equals(this.decoratedEntityType, decorator.decoratedEntityType)) {
            return false;
        }
        return Utils.safe_equals(this.decorated, decorator.decorated);
    }

    @Override
    protected String toString(String prefix) {
        return super.toString(prefix) + '\n' + this.decorated.toString("  " + prefix);
    }

    @Override
    public StringBuilder getHandle(StringBuilder sb) {
        super.getHandle(sb).append('(').append(this.name).append(',').append(this.decoratedEntityType).append(')').append('{');
        return this.decorated.getHandle(sb).append('}');
    }

    @Override
    public String getSimpleName() {
        return "led";
    }

    public String getLinkName() {
        return this.name;
    }

    public String getLinkEntityType() {
        return this.decoratedEntityType;
    }
}

