/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.query;

import java.util.ArrayList;
import java.util.List;
import jetbrains.exodus.query.And;
import jetbrains.exodus.query.CommutativeOperator;
import jetbrains.exodus.query.LinkEqualToLinkNotNull;
import jetbrains.exodus.query.MergePropertyRanges;
import jetbrains.exodus.query.Minus;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.NodeFactory;
import jetbrains.exodus.query.OptimizationRule;
import jetbrains.exodus.query.Or;
import jetbrains.exodus.query.PropertyEqualToPropertyNoNull;
import jetbrains.exodus.query.Root;
import jetbrains.exodus.query.UnaryNot;
import jetbrains.exodus.query.Wildcard;

public class OptimizationPlan {
    private static final NodeBase ALL = NodeFactory.all();
    private static final NodeBase PE2PNN = new PropertyEqualToPropertyNoNull(0);
    private static final NodeBase LE2LNN = new LinkEqualToLinkNotNull(0);
    private static final NodeBase MPR = new MergePropertyRanges(0);
    private static final NodeBase A = OptimizationPlan.wildcard(0);
    private static final NodeBase B = OptimizationPlan.wildcard(1);
    private static final NodeBase C = OptimizationPlan.wildcard(2);
    private static final NodeBase D = OptimizationPlan.wildcard(3);
    static final List<OptimizationPlan> PLANS;
    final List<OptimizationRule> rules = new ArrayList<OptimizationRule>();

    public static UnaryNot not(NodeBase child) {
        return new UnaryNot(child);
    }

    public static Or or(NodeBase left, NodeBase right) {
        return new Or(left, right);
    }

    public static Minus minus(NodeBase left, NodeBase right) {
        return new Minus(left, right);
    }

    public static And and(NodeBase left, NodeBase right) {
        return new And(left, right);
    }

    public static Wildcard wildcard(int t) {
        return new Wildcard(t);
    }

    private OptimizationPlan() {
    }

    public void add(NodeBase source, NodeBase dest) {
        int n = 0;
        for (NodeBase node : source.getDescendants()) {
            if (!(node instanceof CommutativeOperator)) continue;
            ++n;
        }
        for (int i = 0; i < 1 << n; ++i) {
            Root root = new Root(source.getClone());
            int j = 0;
            for (NodeBase node : root.getDescendants()) {
                if (!(node instanceof CommutativeOperator)) continue;
                if ((i & 1 << j) != 0) {
                    ((CommutativeOperator)node).flipChildren();
                }
                ++j;
            }
            this.rules.add(new OptimizationRule(root.getChild(), dest));
        }
    }

    static {
        OptimizationPlan prepare = new OptimizationPlan();
        OptimizationPlan optimize = new OptimizationPlan();
        OptimizationPlan pushNotUpAndGenMinus = new OptimizationPlan();
        OptimizationPlan removeSingleNot = new OptimizationPlan();
        ArrayList<OptimizationPlan> plans = new ArrayList<OptimizationPlan>(4);
        plans.add(prepare);
        plans.add(optimize);
        plans.add(pushNotUpAndGenMinus);
        plans.add(removeSingleNot);
        PLANS = plans;
        prepare.add(OptimizationPlan.minus(A, B), OptimizationPlan.and(A, OptimizationPlan.not(B)));
        optimize.add(OptimizationPlan.and(OptimizationPlan.or(A, B), OptimizationPlan.or(A, C)), OptimizationPlan.or(A, OptimizationPlan.and(B, C)));
        optimize.add(OptimizationPlan.or(OptimizationPlan.and(A, B), OptimizationPlan.and(A, C)), OptimizationPlan.and(A, OptimizationPlan.or(B, C)));
        optimize.add(OptimizationPlan.and(ALL, A), A);
        optimize.add(OptimizationPlan.or(ALL, A), ALL);
        optimize.add(OptimizationPlan.and(A, OptimizationPlan.not(OptimizationPlan.and(A, OptimizationPlan.not(B)))), OptimizationPlan.and(A, B));
        optimize.add(OptimizationPlan.and(OptimizationPlan.and(A, B), B), OptimizationPlan.and(A, B));
        optimize.add(OptimizationPlan.or(OptimizationPlan.or(OptimizationPlan.and(A, B), C), OptimizationPlan.and(D, B)), OptimizationPlan.or(OptimizationPlan.and(OptimizationPlan.or(A, D), B), C));
        optimize.add(MPR, MPR);
        pushNotUpAndGenMinus.add(OptimizationPlan.not(OptimizationPlan.not(A)), A);
        pushNotUpAndGenMinus.add(OptimizationPlan.and(OptimizationPlan.not(A), OptimizationPlan.not(B)), OptimizationPlan.not(OptimizationPlan.or(A, B)));
        pushNotUpAndGenMinus.add(OptimizationPlan.or(OptimizationPlan.not(A), OptimizationPlan.not(B)), OptimizationPlan.not(OptimizationPlan.and(A, B)));
        pushNotUpAndGenMinus.add(OptimizationPlan.and(A, OptimizationPlan.not(B)), OptimizationPlan.minus(A, B));
        pushNotUpAndGenMinus.add(OptimizationPlan.or(A, OptimizationPlan.not(B)), OptimizationPlan.not(OptimizationPlan.minus(B, A)));
        pushNotUpAndGenMinus.add(OptimizationPlan.minus(OptimizationPlan.minus(A, B), B), OptimizationPlan.minus(A, B));
        pushNotUpAndGenMinus.add(OptimizationPlan.and(A, PE2PNN), OptimizationPlan.minus(A, PE2PNN));
        pushNotUpAndGenMinus.add(OptimizationPlan.or(A, PE2PNN), OptimizationPlan.not(OptimizationPlan.minus(PE2PNN, A)));
        pushNotUpAndGenMinus.add(PE2PNN, OptimizationPlan.not(PE2PNN));
        pushNotUpAndGenMinus.add(OptimizationPlan.and(A, LE2LNN), OptimizationPlan.minus(A, LE2LNN));
        pushNotUpAndGenMinus.add(OptimizationPlan.or(A, LE2LNN), OptimizationPlan.not(OptimizationPlan.minus(LE2LNN, A)));
        pushNotUpAndGenMinus.add(LE2LNN, OptimizationPlan.not(LE2LNN));
        removeSingleNot.add(OptimizationPlan.not(A), OptimizationPlan.minus(ALL, A));
    }
}

