/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.query;

import java.util.Objects;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.QueryEngine;
import jetbrains.exodus.query.Utils;
import jetbrains.exodus.query.metadata.ModelMetaData;
import org.jetbrains.annotations.NotNull;

public class PropertyRange
extends NodeBase {
    private final String name;
    @NotNull
    private final Comparable min;
    @NotNull
    private final Comparable max;

    public PropertyRange(String name, @NotNull Comparable min, @NotNull Comparable max) {
        this.name = name;
        this.min = Objects.requireNonNull(min);
        this.max = Objects.requireNonNull(max);
    }

    @Override
    public Iterable<Entity> instantiate(String entityType, QueryEngine queryEngine, ModelMetaData metaData) {
        queryEngine.assertOperational();
        return queryEngine.getPersistentStore().getAndCheckCurrentTransaction().find(entityType, this.name, this.min, this.max);
    }

    PropertyRange merge(PropertyRange range) {
        return new PropertyRange(this.name, this.min.compareTo(range.min) < 0 ? range.min : this.min, this.max.compareTo(range.max) < 0 ? this.max : range.max);
    }

    String getPropertyName() {
        return this.name;
    }

    @Override
    public NodeBase getClone() {
        return new PropertyRange(this.name, this.min, this.max);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        this.checkWildcard(obj);
        if (!(obj instanceof PropertyRange)) {
            return false;
        }
        PropertyRange propertyRange = (PropertyRange)obj;
        return Utils.safe_equals(this.name, propertyRange.name) && Utils.safe_equals(this.min, propertyRange.min) && Utils.safe_equals(this.max, propertyRange.max);
    }

    @Override
    public String toString(String prefix) {
        return super.toString(prefix) + '(' + this.min + "<=" + this.name + "<=" + this.max + ") ";
    }

    @Override
    public StringBuilder getHandle(StringBuilder sb) {
        return super.getHandle(sb).append('(').append(this.min).append('<').append(this.name).append('<').append(this.max).append(')');
    }

    @Override
    public String getSimpleName() {
        return "pr";
    }
}

