/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.query;

import java.util.Collection;
import jetbrains.exodus.core.dataStructures.NanoSet;
import jetbrains.exodus.query.NodeBase;

public abstract class UnaryNode
extends NodeBase {
    protected NodeBase child;
    private Collection<NodeBase> children;

    protected UnaryNode(NodeBase child) {
        this.child = UnaryNode.getUnderRoot(child);
        this.child.setParent(this);
    }

    public NodeBase getChild() {
        return this.child;
    }

    @Override
    public NodeBase replaceChild(NodeBase child, NodeBase newChild) {
        if (this.child != child) {
            throw new RuntimeException(this.getClass() + ": can't replace not own child.");
        }
        this.child = newChild;
        this.children = null;
        newChild.setParent(this);
        return child;
    }

    @Override
    public Collection<NodeBase> getChildren() {
        if (this.children == null) {
            this.children = new NanoSet((Object)this.child);
        }
        return this.children;
    }

    @Override
    public StringBuilder getHandle(StringBuilder sb) {
        super.getHandle(sb).append('{');
        return this.child.getHandle(sb).append('}');
    }

    @Override
    boolean matchChildren(NodeBase node, NodeBase.MatchContext ctx) {
        return this.child.match(((UnaryNode)node).child, ctx);
    }
}

