/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.query.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import jetbrains.exodus.core.dataStructures.NanoSet;
import jetbrains.exodus.core.dataStructures.decorators.HashMapDecorator;
import jetbrains.exodus.core.dataStructures.decorators.LinkedHashSetDecorator;
import jetbrains.exodus.core.dataStructures.hash.HashMap;
import jetbrains.exodus.core.dataStructures.hash.HashSet;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.metadata.AssociationEndMetaData;
import jetbrains.exodus.query.metadata.AssociationEndType;
import jetbrains.exodus.query.metadata.EntityMetaData;
import jetbrains.exodus.query.metadata.Index;
import jetbrains.exodus.query.metadata.IndexField;
import jetbrains.exodus.query.metadata.ModelMetaData;
import jetbrains.exodus.query.metadata.PropertyMetaData;
import jetbrains.exodus.util.StringInterner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityMetaDataImpl
implements EntityMetaData {
    private final AtomicReference<ModelMetaData> modelMetaData;
    private String type = null;
    private String superType = null;
    private Set<String> interfaces = new LinkedHashSetDecorator();
    private Runnable initializer = null;
    private boolean removeOrphan = true;
    private boolean isAbstract = false;
    private Set<String> subTypes = new LinkedHashSetDecorator();
    private List<String> thisAndSuperTypes = Collections.emptyList();
    private Set<AssociationEndMetaData> externalAssociationEnds = null;
    private Map<String, PropertyMetaData> properties = new HashMapDecorator();
    private Set<Index> ownIndexes = Collections.emptySet();
    private Set<String> requiredProperties = Collections.emptySet();
    private Set<String> requiredIfProperties = Collections.emptySet();
    private volatile Map<String, Set<Index>> fieldToIndexes = null;
    private volatile Set<Index> indexes = null;
    private volatile List<String> allSubTypes = null;
    private volatile Map<String, Set<String>> incomingAssociations = null;
    private volatile Ends ends = null;

    public EntityMetaDataImpl() {
        this.modelMetaData = new AtomicReference();
    }

    public EntityMetaDataImpl(@NotNull ModelMetaData modelMetaData) {
        this.modelMetaData = new AtomicReference<ModelMetaData>(modelMetaData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reset() {
        EntityMetaDataImpl entityMetaDataImpl = this;
        synchronized (entityMetaDataImpl) {
            this.allSubTypes = null;
            this.incomingAssociations = null;
            this.indexes = null;
            this.fieldToIndexes = null;
            this.ends = null;
        }
    }

    void resetSelfAndSubtypes() {
        this.reset();
        for (String st : this.getSubTypes()) {
            ((EntityMetaDataImpl)this.getEntityMetaData(st)).reset();
        }
    }

    Set<AssociationEndMetaData> getExternalAssociationEnds() {
        return this.externalAssociationEnds;
    }

    @Override
    public ModelMetaData getModelMetaData() {
        return this.modelMetaData.get();
    }

    public void setModelMetaData(ModelMetaData modelMetaData) {
        if (!this.modelMetaData.compareAndSet(null, modelMetaData)) {
            throw new IllegalStateException("Cannot reuse EntityMetaDataImpl between " + modelMetaData + " and " + this.modelMetaData.get());
        }
    }

    public void setType(String type) {
        this.type = StringInterner.intern((String)type);
    }

    public void setSuperType(String superType) {
        this.superType = StringInterner.intern((String)superType);
        this.resetSelfAndSubtypes();
    }

    @Override
    public Iterable<String> getThisAndSuperTypes() {
        return this.thisAndSuperTypes;
    }

    void setThisAndSuperTypes(List<String> thisAndSuperTypes) {
        this.thisAndSuperTypes = thisAndSuperTypes;
    }

    @Override
    public boolean hasSubTypes() {
        return !this.subTypes.isEmpty();
    }

    @Override
    public boolean isAbstract() {
        return this.isAbstract;
    }

    public void setAbstract(boolean anAbstract) {
        this.isAbstract = anAbstract;
    }

    @Override
    public Collection<String> getSubTypes() {
        return this.subTypes;
    }

    @Override
    public Collection<String> getAllSubTypes() {
        if (!this.hasSubTypes()) {
            return Collections.emptyList();
        }
        this.updateAllSubTypes();
        return this.allSubTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAllSubTypes() {
        if (this.allSubTypes == null) {
            EntityMetaDataImpl entityMetaDataImpl = this;
            synchronized (entityMetaDataImpl) {
                if (this.allSubTypes == null) {
                    ArrayList<String> _allSubTypes = new ArrayList<String>();
                    this.collectSubTypes(this, _allSubTypes);
                    this.allSubTypes = _allSubTypes;
                }
            }
        }
    }

    private void collectSubTypes(EntityMetaDataImpl emd, List<String> result) {
        Set<String> subTypes = emd.subTypes;
        result.addAll(subTypes);
        for (String subType : subTypes) {
            this.collectSubTypes((EntityMetaDataImpl)this.modelMetaData.get().getEntityMetaData(subType), result);
        }
    }

    void addSubType(@NotNull String type) {
        this.subTypes.add(type);
    }

    public void setInitializer(Runnable initializer) {
        this.initializer = initializer;
    }

    @Override
    public Runnable getInitializer() {
        return this.initializer;
    }

    public void setRemoveOrphan(boolean removeOrphan) {
        this.removeOrphan = removeOrphan;
    }

    public void setIsAbstract(boolean anAbstract) {
        this.isAbstract = anAbstract;
    }

    public void setAssociationEndsMetaData(@NotNull Collection<AssociationEndMetaData> ends) {
        this.externalAssociationEnds = new HashSet();
        this.externalAssociationEnds.addAll(ends);
    }

    public void setAssociationEnds(@NotNull Collection<AssociationEndMetaData> ends) {
        this.externalAssociationEnds = new HashSet();
        this.externalAssociationEnds.addAll(ends);
    }

    @Override
    public Collection<String> getInterfaceTypes() {
        return this.interfaces;
    }

    public void setInterfaces(List<String> interfaces) {
        this.interfaces.addAll(interfaces);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addAssociationEndMetaData(AssociationEndMetaData end) {
        EntityMetaDataImpl entityMetaDataImpl = this;
        synchronized (entityMetaDataImpl) {
            AssociationEndMetaData a;
            if (this.externalAssociationEnds == null) {
                this.externalAssociationEnds = new HashSet();
            }
            if ((a = this.findAssociationEndMetaData(end.getName())) != null) {
                throw new IllegalArgumentException("Association already exists [" + end.getName() + ']');
            }
            this.resetSelfAndSubtypes();
            this.externalAssociationEnds.add(end);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AssociationEndMetaData removeAssociationEndMetaData(String name) {
        EntityMetaDataImpl entityMetaDataImpl = this;
        synchronized (entityMetaDataImpl) {
            AssociationEndMetaData a = this.findAssociationEndMetaData(name);
            if (a == null) {
                throw new IllegalArgumentException("Can't find association end with name [" + name + ']');
            }
            this.resetSelfAndSubtypes();
            this.externalAssociationEnds.remove(a);
            return a;
        }
    }

    private AssociationEndMetaData findAssociationEndMetaData(String name) {
        if (this.externalAssociationEnds != null) {
            for (AssociationEndMetaData a : this.externalAssociationEnds) {
                if (!a.getName().equals(name)) continue;
                return a;
            }
        }
        return null;
    }

    @Override
    @NotNull
    public String getType() {
        return this.type;
    }

    @Override
    @Nullable
    public String getSuperType() {
        return this.superType;
    }

    @Override
    public AssociationEndMetaData getAssociationEndMetaData(@NotNull String name) {
        return (AssociationEndMetaData)this.getAssociationEnds().associationEnds.get(name);
    }

    @Override
    @NotNull
    public Collection<AssociationEndMetaData> getAssociationEndsMetaData() {
        return this.getAssociationEnds().associationEnds.values();
    }

    @Override
    public PropertyMetaData getPropertyMetaData(String name) {
        return this.properties.get(name);
    }

    @Override
    @NotNull
    public Iterable<PropertyMetaData> getPropertiesMetaData() {
        return this.properties.values();
    }

    public void setPropertiesMetaData(Iterable<PropertyMetaData> properties) {
        if (properties == null) {
            return;
        }
        for (PropertyMetaData p : properties) {
            this.properties.put(p.getName(), p);
        }
    }

    @Override
    public boolean getRemoveOrphan() {
        return this.removeOrphan;
    }

    @Override
    public boolean hasAggregationChildEnds() {
        return !this.getAssociationEnds().aggregationChildEnds.isEmpty();
    }

    @Override
    public Set<String> getAggregationChildEnds() {
        return this.getAssociationEnds().aggregationChildEnds;
    }

    @Override
    @NotNull
    public Map<String, Set<String>> getIncomingAssociations(ModelMetaData mmd) {
        this.updateIncommingAssociations(mmd);
        return this.incomingAssociations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateIncommingAssociations(ModelMetaData mmd) {
        if (this.incomingAssociations == null) {
            EntityMetaDataImpl entityMetaDataImpl = this;
            synchronized (entityMetaDataImpl) {
                if (this.incomingAssociations == null) {
                    HashMapDecorator result = new HashMapDecorator();
                    for (EntityMetaData emd : mmd.getEntitiesMetaData()) {
                        for (AssociationEndMetaData aemd : emd.getAssociationEndsMetaData()) {
                            if (this.type.equals(aemd.getOppositeEntityMetaData().getType())) {
                                this.collectLink((Map<String, Set<String>>)result, emd, aemd);
                                continue;
                            }
                            Collection<String> associationEndSubtypes = aemd.getOppositeEntityMetaData().getAllSubTypes();
                            if (!associationEndSubtypes.contains(this.type)) continue;
                            this.collectLink((Map<String, Set<String>>)result, emd, aemd);
                        }
                    }
                    this.incomingAssociations = result;
                }
            }
        }
    }

    private void collectLink(Map<String, Set<String>> incomingAssociations, EntityMetaData emd, AssociationEndMetaData aemd) {
        String associationName = aemd.getName();
        this.addIncomingAssociation(incomingAssociations, emd.getType(), associationName);
    }

    private void addIncomingAssociation(@NotNull Map<String, Set<String>> incomingAssociations, @NotNull String type, @NotNull String associationName) {
        HashSet links = incomingAssociations.get(type);
        if (links == null) {
            links = new HashSet();
            incomingAssociations.put(type, (Set<String>)links);
        }
        links.add((String)associationName);
    }

    @Override
    @NotNull
    public Set<Index> getOwnIndexes() {
        return this.ownIndexes;
    }

    @Override
    @NotNull
    public Set<Index> getIndexes() {
        this.updateIndexes();
        return this.indexes;
    }

    @Override
    @NotNull
    public Set<Index> getIndexes(String field) {
        this.updateIndexes();
        Set<Index> res = this.fieldToIndexes.get(field);
        return res == null ? Collections.emptySet() : res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateIndexes() {
        if (this.indexes == null || this.fieldToIndexes == null) {
            EntityMetaDataImpl entityMetaDataImpl = this;
            synchronized (entityMetaDataImpl) {
                HashSet result;
                Set<Index> currentIndexes = this.indexes;
                if (currentIndexes == null) {
                    result = new HashSet();
                    for (String t : this.getThisAndSuperTypes()) {
                        for (Index index : this.getEntityMetaData(t).getOwnIndexes()) {
                            String entityType = index.getOwnerEntityType();
                            for (String st : this.getEntityMetaData(entityType).getThisAndSuperTypes()) {
                                result.addAll(this.getEntityMetaData(st).getOwnIndexes());
                            }
                        }
                    }
                    this.indexes = currentIndexes = EntityMetaDataImpl.copySet(result);
                }
                if (this.fieldToIndexes == null) {
                    result = new HashMap();
                    for (Index index : currentIndexes) {
                        for (IndexField f : index.getFields()) {
                            Set fieldIndexes = (Set)result.get((Object)f.getName());
                            if (fieldIndexes == null) {
                                fieldIndexes = new HashSet();
                                result.put((Object)f.getName(), (Object)fieldIndexes);
                            }
                            fieldIndexes.add(index);
                        }
                    }
                    this.fieldToIndexes = result;
                }
            }
        }
    }

    private EntityMetaData getEntityMetaData(String type) {
        return this.modelMetaData.get().getEntityMetaData(type);
    }

    public void setOwnIndexes(Set<Index> ownIndexes) {
        this.ownIndexes = ownIndexes;
    }

    @Override
    @NotNull
    public Set<String> getRequiredProperties() {
        return this.requiredProperties;
    }

    @Override
    @NotNull
    public Set<String> getRequiredIfProperties(Entity e) {
        return this.requiredIfProperties;
    }

    public void setRequiredProperties(@NotNull Set<String> requiredProperties) {
        this.requiredProperties = EntityMetaDataImpl.copySet(requiredProperties);
    }

    public void setRequiredIfProperties(@NotNull Set<String> requiredIfProperties) {
        this.requiredIfProperties = EntityMetaDataImpl.copySet(requiredIfProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private Ends getAssociationEnds() {
        Ends result = this.ends;
        if (result == null) {
            EntityMetaDataImpl entityMetaDataImpl = this;
            synchronized (entityMetaDataImpl) {
                result = this.ends;
                if (result == null) {
                    if (this.externalAssociationEnds == null) {
                        result = new Ends();
                    } else {
                        result = new Ends((Map)new HashMap(this.externalAssociationEnds.size()), (Set)new LinkedHashSetDecorator());
                        for (AssociationEndMetaData aemd : this.externalAssociationEnds) {
                            result.associationEnds.put(aemd.getName(), aemd);
                            if (aemd.getAssociationEndType() != AssociationEndType.ChildEnd) continue;
                            result.aggregationChildEnds.add(aemd.getName());
                        }
                    }
                    this.ends = result;
                }
            }
        }
        return result;
    }

    public String toString() {
        return this.type;
    }

    private static <E> Set<E> copySet(@NotNull Set<E> origin) {
        int size = origin.size();
        if (size == 0) {
            return Collections.emptySet();
        }
        if (size == 1) {
            return new NanoSet(origin.iterator().next());
        }
        return new HashSet(origin);
    }

    private static class Ends {
        private final Map<String, AssociationEndMetaData> associationEnds;
        private final Set<String> aggregationChildEnds;

        private Ends() {
            this(Collections.emptyMap(), Collections.emptySet());
        }

        private Ends(@NotNull Map<String, AssociationEndMetaData> associationEnds, @NotNull Set<String> aggregationChildEnds) {
            this.associationEnds = associationEnds;
            this.aggregationChildEnds = aggregationChildEnds;
        }
    }
}

