/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.dataStructures;

import java.util.Arrays;

public class LongArrayList
implements Cloneable {
    private long[] data;
    private int size;

    public LongArrayList(int initialCapacity) {
        this.data = new long[initialCapacity];
    }

    public LongArrayList() {
        this(4);
    }

    public void trimToSize() {
        int oldCapacity = this.data.length;
        if (this.size < oldCapacity) {
            long[] oldData = this.data;
            this.data = new long[this.size];
            System.arraycopy(oldData, 0, this.data, 0, this.size);
        }
    }

    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.data.length;
        if (minCapacity > oldCapacity) {
            int newCapacity;
            if (oldCapacity == 0) {
                oldCapacity = 1;
            }
            if ((newCapacity = (oldCapacity << 3) / 5 + 1) < minCapacity) {
                newCapacity = minCapacity;
            }
            long[] oldData = this.data;
            this.data = new long[newCapacity];
            System.arraycopy(oldData, 0, this.data, 0, this.size);
        }
    }

    public int getCapacity() {
        return this.data.length;
    }

    public void setCapacity(int capacity) {
        this.data = new long[capacity];
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean contains(long element) {
        return this.indexOf(element) >= 0;
    }

    public int indexOf(long element) {
        return LongArrayList.indexOf(this.data, this.size, element);
    }

    public static int indexOf(long[] array, long element) {
        return LongArrayList.indexOf(array, array.length, element);
    }

    public static int indexOf(long[] array, int size, long element) {
        for (int i = 0; i < size; ++i) {
            if (element != array[i]) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(long element) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (element != this.data[i]) continue;
            return i;
        }
        return -1;
    }

    public void sort() {
        Arrays.sort(this.data, 0, this.size);
    }

    public final Object clone() throws CloneNotSupportedException {
        LongArrayList v = (LongArrayList)super.clone();
        v.data = new long[this.size];
        System.arraycopy(this.data, 0, v.data, 0, this.size);
        return v;
    }

    public long[] toArray() {
        long[] result = new long[this.size];
        System.arraycopy(this.data, 0, result, 0, this.size);
        return result;
    }

    public long[] toArray(long[] a) {
        if (a.length < this.size) {
            a = new long[this.size];
        }
        System.arraycopy(this.data, 0, a, 0, this.size);
        return a;
    }

    public long[] getInstantArray() {
        return this.data;
    }

    public long get(int index) {
        this.checkRange(index);
        return this.data[index];
    }

    public long set(int index, long element) {
        this.checkRange(index);
        long oldValue = this.data[index];
        this.data[index] = element;
        return oldValue;
    }

    public void add(long element) {
        this.ensureCapacity(this.size + 1);
        this.data[this.size++] = element;
    }

    public void add(int index, long element) {
        if (index > this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.data, index, this.data, index + 1, this.size - index);
        this.data[index] = element;
        ++this.size;
    }

    public long remove(int index) {
        this.checkRange(index);
        long oldValue = this.data[index];
        int numMoved = this.size - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.data, index + 1, this.data, index, numMoved);
        }
        --this.size;
        return oldValue;
    }

    public void clear() {
        this.size = 0;
    }

    protected void removeRange(int fromIndex, int toIndex) {
        int numMoved = this.size - toIndex;
        System.arraycopy(this.data, toIndex, this.data, fromIndex, numMoved);
        this.size -= toIndex - fromIndex;
    }

    private void checkRange(int index) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
    }
}

