/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.dataStructures.decorators;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import jetbrains.exodus.core.dataStructures.hash.HashSet;

public class HashSetDecorator<E>
implements Set<E> {
    private Set<E> decorated;

    public HashSetDecorator() {
        this.clear();
    }

    public HashSetDecorator(Collection<? extends E> c) {
        this();
        this.addAll(c);
    }

    @Override
    public int size() {
        return this.decorated.size();
    }

    @Override
    public boolean isEmpty() {
        return this.decorated == Collections.emptySet() || this.decorated.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.decorated.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.decorated.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.decorated.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.decorated.toArray(a);
    }

    @Override
    public boolean add(E e) {
        this.checkDecorated();
        return this.decorated.add(e);
    }

    @Override
    public boolean remove(Object o) {
        if (this.decorated == Collections.emptySet()) {
            return false;
        }
        boolean result = this.decorated.remove(o);
        if (result && this.decorated.isEmpty()) {
            this.clear();
        }
        return result;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.decorated.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        this.checkDecorated();
        return this.decorated.addAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.checkDecorated();
        return this.decorated.retainAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (this.decorated == Collections.emptySet()) {
            return false;
        }
        boolean result = this.decorated.removeAll(c);
        if (result && this.decorated.isEmpty()) {
            this.clear();
        }
        return result;
    }

    @Override
    public void clear() {
        this.decorated = Collections.emptySet();
    }

    private void checkDecorated() {
        if (this.decorated == Collections.emptySet()) {
            this.decorated = new HashSet();
        }
    }
}

