/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.execution;

import java.util.Set;
import jetbrains.exodus.core.dataStructures.decorators.QueueDecorator;
import jetbrains.exodus.core.dataStructures.hash.HashSet;
import jetbrains.exodus.core.execution.Job;
import jetbrains.exodus.core.execution.JobProcessor;
import jetbrains.exodus.core.execution.ThreadJobProcessorPool;
import org.jetbrains.annotations.NotNull;

public class SharedTimer {
    private static int PERIOD = 1000;
    private static final Set<ExpirablePeriodicTask> registeredTasks = new HashSet<ExpirablePeriodicTask>();
    private static final JobProcessor processor = ThreadJobProcessorPool.getOrCreateJobProcessor("Exodus shared timer thread");

    private SharedTimer() {
    }

    public static void registerPeriodicTask(final @NotNull ExpirablePeriodicTask task) {
        processor.queue(new Job(){

            @Override
            protected void execute() {
                registeredTasks.add(task);
            }
        });
    }

    public static void unregisterPeriodicTask(final @NotNull ExpirablePeriodicTask task) {
        processor.queue(new Job(){

            @Override
            protected void execute() {
                registeredTasks.remove(task);
            }
        });
    }

    static {
        processor.queueIn(new Ticker(), PERIOD);
    }

    private static class Ticker
    extends Job {
        private Ticker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void execute() {
            long nextTick = System.currentTimeMillis() + (long)PERIOD;
            QueueDecorator<ExpirablePeriodicTask> expiredTasks = new QueueDecorator<ExpirablePeriodicTask>();
            try {
                for (ExpirablePeriodicTask task : registeredTasks) {
                    if (task.isExpired()) {
                        expiredTasks.add(task);
                        continue;
                    }
                    task.run();
                }
                if (!expiredTasks.isEmpty()) {
                    for (ExpirablePeriodicTask expiredTask : expiredTasks) {
                        registeredTasks.remove(expiredTask);
                    }
                }
            }
            finally {
                processor.queueAt(this, nextTick);
            }
        }
    }

    public static interface ExpirablePeriodicTask
    extends Runnable {
        public boolean isExpired();
    }
}

