/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.management;

import java.lang.management.ManagementFactory;
import javax.management.InstanceNotFoundException;
import javax.management.ObjectName;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MBeanBase {
    @NotNull
    private final ObjectName name;
    @Nullable
    private Runnable runOnClose;

    protected MBeanBase(@NotNull String objectName) {
        try {
            this.name = new ObjectName(objectName);
            ManagementFactory.getPlatformMBeanServer().registerMBean(this, this.name);
        }
        catch (Exception e) {
            throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
        }
    }

    @NotNull
    public ObjectName getName() {
        return this.name;
    }

    public void close() {
        Runnable runOnClose = this.runOnClose;
        if (runOnClose != null) {
            runOnClose.run();
        }
    }

    public void unregister() {
        try {
            ManagementFactory.getPlatformMBeanServer().unregisterMBean(this.name);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
        }
        catch (Exception e) {
            throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
        }
    }

    public void runOnClose(@Nullable Runnable runnable) {
        this.runOnClose = runnable;
    }

    protected static String escapeLocation(@NotNull String location) {
        return location.indexOf(58) >= 0 ? location.replace(':', '@') : location;
    }
}

