/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.api.commands;

import java.util.Locale;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.youtrack.api.parser.IField;
import org.jetbrains.annotations.Nullable;

public enum PredefinedCommandType {
    add("predefined_command_type.add"),
    remove("predefined_command_type.remove"),
    comment("predefined_command_type.comment"),
    delete("predefined_command_type.delete"),
    untag("predefined_command_type.untag", remove),
    unstar("predefined_command_type.unstar", remove),
    vote("PredefinedCommandType.vote"),
    plusOne("PredefinedCommandType.plusOne"),
    unvote("PredefinedCommandType.unvote");

    private String localizationId;
    private IField testCategory = null;
    private PredefinedCommandType command = null;

    private PredefinedCommandType(String localizationId) {
        this.localizationId = localizationId;
    }

    private PredefinedCommandType(String localizationId, PredefinedCommandType command) {
        this.localizationId = localizationId;
        this.command = command;
    }

    public String getName(Locale locale) {
        return ((Localizer)ServiceLocator.getBean((String)"localizer")).getMsgInLocale(this.localizationId, locale, new Object[0]);
    }

    public boolean isComposite() {
        return this.getCategory() != null && this.command != null;
    }

    public String toString() {
        return ((Localizer)ServiceLocator.getBean((String)"localizer")).getDefaultMsg(this.localizationId, new Object[0]);
    }

    @Nullable
    public IField getCategory() {
        if (this.testCategory != null) {
            return this.testCategory;
        }
        IField category = null;
        if (this == untag) {
            category = (IField)ServiceLocator.getBean((String)"predefinedFieldTag");
        } else if (this == unstar) {
            category = (IField)ServiceLocator.getBean((String)"predefinedFieldStar");
        }
        return category;
    }

    public void setCategoryForTests(IField baseField) {
        this.testCategory = baseField;
    }

    public void resetCategoryForTests() {
        this.testCategory = null;
    }

    @Nullable
    public PredefinedCommandType getCommand() {
        return this.command;
    }
}

