/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.api.misc;

import java.net.UnknownHostException;
import jetbrains.mps.baseLanguage.dates.runtime.DateTimeOperations;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.youtrack.core.dates.DateFormats;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;

public class UpdateCheckResult {
    private static final UpdateCheckResult NOTHING_FOUND_TO_UPDATE = new LocalizedUpdateCheckResult(true, false, "UpdateCheckResult.Nothing_found_to_update");
    private static final UpdateCheckResult UPDATE_INFO_UNAVAILABLE = new LocalizedUpdateCheckResult(true, false, "UpdateCheckResult.Update_info_is_not_available");
    private static final UpdateCheckResult FAIL = new LocalizedUpdateCheckResult(false, false, "UpdateCheckResult.Update_info_is_not_available");
    protected static Log log = LogFactory.getLog(UpdateCheckResult.class);
    private boolean mySuccess;
    private boolean myUpdateAvailable;
    private String myMessage;
    private Long myDate;
    private String myDownloadUrl;

    public UpdateCheckResult(boolean success, boolean updateAvailable, String message) {
        this.setSuccess(success);
        this.setMessage(message);
        this.setUpdateAvailable(updateAvailable);
    }

    public boolean getSuccess() {
        return this.mySuccess;
    }

    private void setSuccess(boolean value) {
        this.mySuccess = value;
    }

    public boolean getUpdateAvailable() {
        return this.myUpdateAvailable;
    }

    private void setUpdateAvailable(boolean value) {
        this.myUpdateAvailable = value;
    }

    public String getMessage() {
        return this.myMessage;
    }

    private void setMessage(String value) {
        this.myMessage = value;
    }

    public Long getDate() {
        return this.myDate;
    }

    private void setDate(Long value) {
        this.myDate = value;
    }

    public String getDownloadUrl() {
        return this.myDownloadUrl;
    }

    private void setDownloadUrl(String value) {
        this.myDownloadUrl = value;
    }

    public static UpdateCheckResult nothingFoundToUpdate() {
        return NOTHING_FOUND_TO_UPDATE;
    }

    public static UpdateCheckResult notAvailable() {
        return UPDATE_INFO_UNAVAILABLE;
    }

    public static UpdateCheckResult available(String message, String date, String downloadUrl) {
        UpdateCheckResult result = new UpdateCheckResult(true, true, message);
        if (date != null && date.length() > 0) {
            try {
                result.setDate(DateTimeOperations.convert((DateTime)DateTimeOperations.parseDateTime((String)date, (DateTimeFormatter)DateFormats.INSTANCE.getFormatter("releaseDateFormat"), (DateTimeZone)DateTimeZone.UTC, null, null)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        result.setDownloadUrl(downloadUrl);
        return result;
    }

    public static UpdateCheckResult fail(Exception e) {
        if (e instanceof UnknownHostException) {
            if (log.isErrorEnabled()) {
                log.error((Object)"DNS resord for jetbrains.com cannot be resolved, skipping update check");
            }
        } else if (log.isErrorEnabled()) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return FAIL;
    }

    private static class LocalizedUpdateCheckResult
    extends UpdateCheckResult {
        private String myLocalizationId;

        public LocalizedUpdateCheckResult(boolean success, boolean updateAvailable, String localizationId) {
            super(success, updateAvailable, null);
            this.setLocalizationId(localizationId);
        }

        @Override
        public String getMessage() {
            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg(this.getLocalizationId(), new Object[0]);
        }

        public String getLocalizationId() {
            return this.myLocalizationId;
        }

        private void setLocalizationId(String value) {
            this.myLocalizationId = value;
        }
    }
}

