/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.api.parser;

import java.util.ArrayList;
import java.util.List;
import jetbrains.mps.internal.collections.runtime.IListSequence;
import jetbrains.mps.internal.collections.runtime.ListSequence;

public enum AliasFlag {
    SORT(1, 's'),
    PRESENTATION(2, 'p'),
    FILTER(3, 'f'),
    VISIBILITY(4, 'v'),
    COMMAND(5, 'c'),
    HAS(6, 'h');

    private final int flag;
    private final char code;

    private AliasFlag(int bit, char code) {
        this.flag = 1 << bit;
        this.code = code;
    }

    public boolean is(int mask) {
        return (mask & this.flag) != 0;
    }

    public static int toMask(AliasFlag ... flags) {
        if (flags == null) {
            return 0;
        }
        int res = 0;
        for (AliasFlag flag : flags) {
            res |= flag != null ? flag.flag : 0;
        }
        return res;
    }

    public static AliasFlag[] decodeFromString(String flags) {
        IListSequence res = ListSequence.fromList(new ArrayList());
        if (flags != null && flags.length() > 0) {
            for (AliasFlag flag : AliasFlag.values()) {
                if (flags.indexOf(flag.code) == -1) continue;
                ListSequence.fromList((List)res).addElement((Object)flag);
            }
        }
        return (AliasFlag[])ListSequence.fromList((List)res).toGenericArray(AliasFlag.class);
    }

    public static AliasFlag[] decodeFromMask(int mask) {
        IListSequence res = ListSequence.fromList(new ArrayList());
        for (AliasFlag flag : AliasFlag.values()) {
            if ((mask & flag.flag) == 0) continue;
            ListSequence.fromList((List)res).addElement((Object)flag);
        }
        return (AliasFlag[])ListSequence.fromList((List)res).toGenericArray(AliasFlag.class);
    }
}

