/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.api.parser;

import jetbrains.youtrack.api.parser.AliasFlag;

public class FieldAlias {
    public static int ALL = AliasFlag.toMask(AliasFlag.values());
    public static int NONE = AliasFlag.toMask(new AliasFlag[0]);
    private final int ordinal;
    private final boolean shouldSuggest;
    private final String alias;
    private int mask;

    public FieldAlias(int ordinal, String alias, int mask) {
        this(ordinal, alias, mask, true);
    }

    public FieldAlias(int ordinal, String alias, int mask, boolean shouldSuggest) {
        this.ordinal = ordinal;
        this.alias = alias;
        this.mask = mask;
        this.shouldSuggest = shouldSuggest;
    }

    public FieldAlias(int ordinal, String alias) {
        this(ordinal, alias, ALL);
    }

    public FieldAlias(int ordinal, String alias, AliasFlag ... flags) {
        this(ordinal, alias, AliasFlag.toMask(flags));
    }

    public FieldAlias(int ordinal, String alias, boolean shouldSuggest, AliasFlag ... flags) {
        this(ordinal, alias, AliasFlag.toMask(flags), shouldSuggest);
    }

    @Deprecated
    public FieldAlias(int ordinal, String alias, boolean presentation, boolean filter, boolean sort, boolean visibility, boolean command, AliasFlag ... flags) {
        this(ordinal, alias, presentation ? AliasFlag.PRESENTATION : null, filter ? AliasFlag.FILTER : null, sort ? AliasFlag.SORT : null, visibility ? AliasFlag.VISIBILITY : null, command ? AliasFlag.COMMAND : null);
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public String getAlias() {
        return this.alias;
    }

    public boolean is(AliasFlag flag) {
        return flag.is(this.mask);
    }

    public boolean isSort() {
        return AliasFlag.SORT.is(this.mask);
    }

    public boolean isPresentation() {
        return AliasFlag.PRESENTATION.is(this.mask);
    }

    public boolean isFilter() {
        return AliasFlag.FILTER.is(this.mask);
    }

    public boolean isVisibility() {
        return AliasFlag.VISIBILITY.is(this.mask);
    }

    public boolean isCommand() {
        return AliasFlag.COMMAND.is(this.mask);
    }

    public boolean isHas() {
        return AliasFlag.HAS.is(this.mask);
    }

    public int getMask() {
        return this.mask;
    }

    public boolean shouldSuggest() {
        return this.shouldSuggest;
    }
}

