/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.eventSource;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import jetbrains.charisma.eventSource.EventSourceTicket;
import jetbrains.gap.resource.Entity;
import jetbrains.gap.resource.Resource;
import jetbrains.gap.resource.WebUtilsKt;
import jetbrains.youtrack.gaprest.exception.LocalizedNotAuthorizedException;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.glassfish.jersey.media.sse.EventOutput;
import org.jetbrains.annotations.NotNull;

@Path(value="eventSourceBus")
@Produces(value={"text/event-stream"})
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J&\u0010\u000f\u001a\u00020\f2\u001e\u0010\u0010\u001a\u001a\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00130\u0011J\b\u0010\u0014\u001a\u00020\u0012H\u0007J\u0006\u0010\u0015\u001a\u00020\u0016J\b\u0010\u0017\u001a\u00020\u0013H\u0002R\u0012\u0010\u0004\u001a\u00020\u00058\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\n\u001a\u001e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bj\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Ljetbrains/charisma/eventSource/EventSourceBusResource;", "Ljetbrains/gap/resource/Resource;", "Ljetbrains/gap/resource/Entity;", "()V", "args", "Ljavax/ws/rs/core/UriInfo;", "connections", "Ljava/util/concurrent/atomic/AtomicLong;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "tickets", "Ljava/util/LinkedHashMap;", "", "Ljetbrains/charisma/eventSource/EventSourceTicket;", "Lkotlin/collections/LinkedHashMap;", "createTicket", "initializer", "Lkotlin/Function3;", "Lorg/glassfish/jersey/media/sse/EventOutput;", "", "events", "hasConnections", "", "removeUnusedTickets", "youtrack-application"})
public final class EventSourceBusResource
implements Resource<Entity> {
    @Context
    private UriInfo args;
    private final LinkedHashMap<String, EventSourceTicket> tickets;
    private final ReentrantLock lock;
    private final AtomicLong connections;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @NotNull
    public final EventOutput events() {
        Object object;
        UriInfo uriInfo = this.args;
        if (uriInfo == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"args");
        }
        String id = WebUtilsKt.get((UriInfo)uriInfo, (String)"ticket");
        Lock lock = this.lock;
        lock.lock();
        try {
            Map map2 = this.tickets;
            object = id;
            Map map3 = map2;
            if (map3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableMap<K, V>");
            }
            object = (EventSourceTicket)TypeIntrinsics.asMutableMap((Object)map3).remove(object);
        }
        finally {
            lock.unlock();
        }
        Object ticket = object;
        if (ticket != null) {
            this.removeUnusedTickets();
            if (((EventSourceTicket)ticket).expired(System.currentTimeMillis())) {
                throw (Throwable)new LocalizedNotAuthorizedException("EventSource.expired_ticket_provided", new Object[]{id});
            }
            UriInfo uriInfo2 = this.args;
            if (uriInfo2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"args");
            }
            return ((EventSourceTicket)ticket).createOutput(uriInfo2, this.connections);
        }
        throw (Throwable)new LocalizedNotAuthorizedException("EventSource.invalid_ticket_provided", new Object[]{id});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String createTicket(@NotNull Function3<? super EventOutput, ? super UriInfo, ? super String, Unit> initializer) {
        Intrinsics.checkParameterIsNotNull(initializer, (String)"initializer");
        EventSourceTicket ticket = new EventSourceTicket(initializer, null, 0L, 6, null);
        Lock lock = this.lock;
        lock.lock();
        try {
            EventSourceTicket eventSourceTicket = this.tickets.put(ticket.getId(), ticket);
        }
        finally {
            lock.unlock();
        }
        return ticket.getId();
    }

    public final boolean hasConnections() {
        return this.connections.get() > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void removeUnusedTickets() {
        long now = System.currentTimeMillis();
        Lock lock = this.lock;
        lock.lock();
        try {
            Map.Entry entry;
            EventSourceTicket ticket;
            Map map2 = this.tickets;
            Iterator itr = map2.entrySet().iterator();
            while (itr.hasNext() && (ticket = (EventSourceTicket)(entry = itr.next()).getValue()).expired(now)) {
                itr.remove();
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    public EventSourceBusResource() {
        EventSourceBusResource eventSourceBusResource = this;
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        eventSourceBusResource.tickets = linkedHashMap;
        this.lock = new ReentrantLock();
        this.connections = new AtomicLong();
    }
}

