/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.keyword;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import jetbrains.charisma.keyword.BeansKt;
import jetbrains.charisma.keyword.FilterField;
import jetbrains.charisma.keyword.FilteredProjectsProvider;
import jetbrains.charisma.keyword.ResourcesKt;
import jetbrains.charisma.main.CollectionUtilKt;
import jetbrains.gap.resource.Entity;
import jetbrains.gap.resource.WebUtilsKt;
import jetbrains.gap.resource.components.SequenceGetter;
import jetbrains.gap.resource.components.impl.delegate.ReadOnlyEntityWithSubResources;
import jetbrains.youtrack.api.parser.IContext;
import jetbrains.youtrack.api.parser.IField;
import jetbrains.youtrack.core.security.Operation;
import jetbrains.youtrack.persistent.PersitenceExtensionsKt;
import jetbrains.youtrack.persistent.XdIssueFolder;
import jetbrains.youtrack.persistent.XdProject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlinx.dnq.XdEntityType;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import webr.framework.controller.BaseApplication;

@Path(value="filterFields")
@Produces(value={"application/json"})
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u0000 \"2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\"B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u00020\r2\b\b\u0001\u0010\u000e\u001a\u00020\u0007H\u0017J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J$\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u0018H\u0002J\u001e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00142\u000e\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u0012H\u0002J\u001e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00142\u000e\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u0012H\u0002J0\u0010\u001e\u001a\u00020\u0016*\u00020\u00022\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00142\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001b0\u00142\u0006\u0010!\u001a\u00020\u0016H\u0002R\u0012\u0010\u0004\u001a\u00020\u00058\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006#"}, d2={"Ljetbrains/charisma/keyword/FilterFieldsResource;", "Ljetbrains/gap/resource/components/SequenceGetter;", "Ljetbrains/charisma/keyword/FilterField;", "()V", "args", "Ljavax/ws/rs/core/UriInfo;", "query", "", "getQuery", "()Ljava/lang/String;", "getAll", "Lkotlin/sequences/Sequence;", "getElementById", "", "id", "getElementResource", "element", "getFilterFieldsByType", "", "types", "", "includeNonFilterFields", "", "getFolders", "", "Ljetbrains/youtrack/persistent/XdIssueFolder;", "getProjectsFromContext", "Ljetbrains/youtrack/persistent/XdProject;", "contextFolders", "getProjectsFromQuery", "matches", "contextProjects", "queryProjects", "isContains", "Companion", "youtrack-application"})
public final class FilterFieldsResource
implements SequenceGetter<FilterField> {
    @Context
    private UriInfo args;
    private static final String TYPES_PARAM = "fieldTypes";
    private static final String PROJECTS_PARAM = "fld";
    private static final String NON_FILTER_FIELD_PARAM = "includeNonFilterFields";
    private static final String FILTERING_TYPE_PARAM = "filteringType";
    public static final Companion Companion = new Companion(null);

    private final String getQuery() {
        String string = BaseApplication.getRequest().getParameter("query");
        if (string == null) {
            string = "";
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Sequence<FilterField> getAll() {
        void $receiver$iv$iv;
        Iterable<FilterField> $receiver$iv;
        Collection collection;
        UriInfo uriInfo = this.args;
        if (uriInfo == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"args");
        }
        if ((collection = (List)uriInfo.getQueryParameters().get((Object)TYPES_PARAM)) == null || (collection = CollectionsKt.toSet((Iterable)collection)) == null) {
            collection = SetsKt.setOf((Object[])new String[]{BeansKt.getPredefinedFilterFieldAware().getTypeWildCard(), BeansKt.getCustomFilterFieldAware().getTypeWildCard(), BeansKt.getBoardSprintFilterFieldAware().getTypeWildCard()});
        }
        Collection acceptedFieldTypes = collection;
        UriInfo uriInfo2 = this.args;
        if (uriInfo2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"args");
        }
        boolean isContainsStrategy = Intrinsics.areEqual((Object)"contains", (Object)WebUtilsKt.get((UriInfo)uriInfo2, (String)FILTERING_TYPE_PARAM));
        UriInfo uriInfo3 = this.args;
        if (uriInfo3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"args");
        }
        boolean includeNonFilterFields = Intrinsics.areEqual((Object)"true", (Object)WebUtilsKt.get((UriInfo)uriInfo3, (String)NON_FILTER_FIELD_PARAM));
        Iterable<FilterField> fields2 = this.getFilterFieldsByType((Set<String>)acceptedFieldTypes, includeNonFilterFields);
        List<XdIssueFolder> folders = this.getFolders();
        Iterable<FilterField> iterable = $receiver$iv = fields2;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            FilterField it = (FilterField)((Object)element$iv$iv);
            if (!this.matches(it, this.getProjectsFromContext((Iterable<? extends XdIssueFolder>)folders), this.getProjectsFromQuery((Iterable<? extends XdIssueFolder>)folders), isContainsStrategy)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.asSequence((Iterable)((List)destination$iv$iv));
    }

    private final Set<XdProject> getProjectsFromQuery(Iterable<? extends XdIssueFolder> contextFolders) {
        Object object;
        Object object2 = this.getQuery();
        if (object2.length() == 0) {
            return SetsKt.emptySet();
        }
        FilteredProjectsProvider filteredProjectsProvider = BeansKt.getFilteredProjectsProvider();
        Iterable<? extends XdIssueFolder> iterable = contextFolders;
        if (iterable != null) {
            object2 = iterable;
            FilteredProjectsProvider filteredProjectsProvider2 = filteredProjectsProvider;
            Object object3 = object2;
            filteredProjectsProvider = filteredProjectsProvider2;
            object = object3;
        } else {
            object = null;
        }
        return CollectionsKt.toSet(filteredProjectsProvider.getPositiveProjects((Iterable<? extends XdIssueFolder>)object, this.getQuery(), (IContext)new jetbrains.charisma.smartui.persistent.Context()));
    }

    /*
     * WARNING - void declaration
     */
    private final Set<XdProject> getProjectsFromContext(Iterable<? extends XdIssueFolder> contextFolders) {
        Set set2;
        block4: {
            block3: {
                void $receiver$iv$iv;
                Set $receiver$iv;
                set2 = contextFolders;
                if (set2 == null) break block3;
                Set set3 = $receiver$iv = set2;
                Collection destination$iv$iv = new ArrayList();
                for (Object element$iv$iv : $receiver$iv$iv) {
                    XdIssueFolder it = (XdIssueFolder)((Object)element$iv$iv);
                    Iterable list$iv$iv = XdQueryKt.asIterable(it.getQueryProjects());
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                set2 = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                if (set2 != null) break block4;
            }
            set2 = SetsKt.emptySet();
        }
        return set2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<XdIssueFolder> getFolders() {
        List list;
        List list2;
        UriInfo uriInfo = this.args;
        if (uriInfo == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"args");
        }
        if ((list2 = (List)uriInfo.getQueryParameters().get((Object)PROJECTS_PARAM)) != null && (list2 = CollectionsKt.distinct((Iterable)list2)) != null) {
            void var3_3;
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)list2;
            Collection destination$iv$iv = new ArrayList();
            void $receiver$iv$iv$iv = $receiver$iv$iv;
            Iterator iterator2 = $receiver$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                XdIssueFolder xdIssueFolder;
                XdIssueFolder folder2;
                String key2;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                String string = key2 = (String)element$iv$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"key");
                XdProject xdProject = XdProject.Companion.findByKey(string);
                if ((xdProject != null ? (XdIssueFolder)xdProject : (XdIssueFolder)((Object)PersitenceExtensionsKt.tryFindById((XdEntityType)XdIssueFolder.Companion, key2))) == null) {
                    throw (Throwable)new BadRequestException("Folder with id: " + key2 + " is not found");
                }
                folder2 = folder2;
                if (!XdIssueFolder.isAccessible$default(folder2, Operation.READ, null, 2, null)) {
                    throw (Throwable)new ForbiddenException("Folder with id: " + key2 + " is not accessible");
                }
                if (folder2 == null) continue;
                XdIssueFolder it$iv$iv = xdIssueFolder;
                destination$iv$iv.add(it$iv$iv);
            }
            list = (List)var3_3;
        } else {
            list = null;
        }
        return list;
    }

    @Path(value="{id}")
    @NotNull
    public Object getElementById(@PathParam(value="id") @NotNull String id) {
        Object object;
        block5: {
            block4: {
                IField iField;
                Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
                object = BeansKt.getFilterFieldAwareCollection().find(id);
                if (object == null) break block4;
                IField it = iField = object;
                object = BeansKt.getFilterFieldAwareCollection().wrap(it);
                if (object != null) break block5;
            }
            throw (Throwable)new NotFoundException("No filter field with id " + id);
        }
        IField field = object;
        List<XdIssueFolder> folders = this.getFolders();
        Set<XdProject> contextProjects = this.getProjectsFromContext((Iterable<? extends XdIssueFolder>)folders);
        Set<XdProject> queryProjects = this.getProjectsFromQuery((Iterable<? extends XdIssueFolder>)folders);
        if (!this.matches((FilterField)field, contextProjects, queryProjects, true)) {
            throw (Throwable)new BadRequestException("No field " + field.getPresentation() + " for these projects");
        }
        field.setQueryProjects(queryProjects);
        field.setContextProjects(contextProjects);
        return this.getElementResource((FilterField)field);
    }

    @NotNull
    public Object getElementResource(@NotNull FilterField element) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)element), (String)"element");
        return new ReadOnlyEntityWithSubResources((Entity)element);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean matches(@NotNull FilterField $receiver, Set<XdProject> contextProjects, Set<XdProject> queryProjects, boolean isContains) {
        Object element$iv;
        XdProject it;
        if (contextProjects.size() == 1 && Intrinsics.areEqual((Object)$receiver.getBaseField(), (Object)BeansKt.getPredefinedFieldProject())) {
            return false;
        }
        Set set2 = ResourcesKt.intersectProjects(contextProjects, queryProjects);
        Collection<Object> it2 = set2;
        Set projects = CollectionUtilKt.isEmpty((Iterable)it2) && isContains ? XdQueryKt.toSet((XdQuery)XdProject.Companion.all()) : it2;
        List<XdProject> list = $receiver.getUsedIn();
        if (list == null) return true;
        List<XdProject> list2 = list;
        it2 = list2;
        if (isContains) {
            Object element$iv2;
            XdProject it3;
            Iterable $receiver$iv = CollectionsKt.intersect((Iterable)it2, (Iterable)projects);
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                return false;
            }
            Iterator iterator2 = $receiver$iv.iterator();
            do {
                if (!iterator2.hasNext()) return false;
            } while (!$receiver.isAccessibleInProject(it3 = (XdProject)((Object)(element$iv2 = iterator2.next()))));
            return true;
        }
        if (!it2.containsAll(projects)) return false;
        Iterable $receiver$iv = projects;
        if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
            return true;
        }
        Iterator iterator3 = $receiver$iv.iterator();
        do {
            if (!iterator3.hasNext()) return true;
        } while ($receiver.isAccessibleInProject(it = (XdProject)((Object)(element$iv = iterator3.next()))));
        return false;
    }

    private final Iterable<FilterField> getFilterFieldsByType(Set<String> types, boolean includeNonFilterFields) {
        return BeansKt.getFilterFieldAwareCollection().getAccessibleFilterFields(jetbrains.charisma.persistent.BeansKt.getXdLoggedInUser(), types, includeNonFilterFields);
    }

    public int getDefaultTopValue() {
        return SequenceGetter.DefaultImpls.getDefaultTopValue((SequenceGetter)this);
    }

    @NotNull
    public Sequence<FilterField> applySecurity(@NotNull Sequence<? extends FilterField> values2) {
        Intrinsics.checkParameterIsNotNull(values2, (String)"values");
        return SequenceGetter.DefaultImpls.applySecurity((SequenceGetter)this, values2);
    }

    public void assertAccess() {
        SequenceGetter.DefaultImpls.assertAccess((SequenceGetter)this);
    }

    @NotNull
    public WebApplicationException elementNotFound(@NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        return SequenceGetter.DefaultImpls.elementNotFound((SequenceGetter)this, (String)id);
    }

    @NotNull
    public Sequence<FilterField> filterAll(@Nullable String query2) {
        return SequenceGetter.DefaultImpls.filterAll((SequenceGetter)this, (String)query2);
    }

    @GET
    @Produces(value={"application/json"})
    @NotNull
    public List<Entity> get(@QueryParam(value="query") @Nullable String query2, @QueryParam(value="$skip") @Nullable Integer skip, @QueryParam(value="$top") @Nullable Integer top) {
        return SequenceGetter.DefaultImpls.get((SequenceGetter)this, (String)query2, (Integer)skip, (Integer)top);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Ljetbrains/charisma/keyword/FilterFieldsResource$Companion;", "", "()V", "FILTERING_TYPE_PARAM", "", "NON_FILTER_FIELD_PARAM", "PROJECTS_PARAM", "TYPES_PARAM", "youtrack-application"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

