/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.main;

import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Set;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import jetbrains.charisma.main.CharismaLicenseChecker;
import jetbrains.charisma.main.CollectionUtilKt;
import jetbrains.charisma.persistent.BeansKt;
import jetbrains.charisma.persistent.globalSettings.License;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.gap.resource.error.ApiError;
import jetbrains.youtrack.gaprest.db.XodusDatabase;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.glassfish.jersey.server.ContainerRequest;
import org.jetbrains.annotations.NotNull;

@Provider
@PreMatching
@Priority(value=5000)
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u0010H\u0002\u00a8\u0006\u0012"}, d2={"Ljetbrains/charisma/main/YouTrackLicenseFilter;", "Ljavax/ws/rs/container/ContainerRequestFilter;", "()V", "abortWithError", "", "context", "Ljavax/ws/rs/container/ContainerRequestContext;", "msg", "", "what", "filter", "getLicenseError", "license", "Ljetbrains/charisma/persistent/globalSettings/License;", "isAllowedRequest", "", "Lorg/glassfish/jersey/server/ContainerRequest;", "Companion", "youtrack-application"})
public final class YouTrackLicenseFilter
implements ContainerRequestFilter {
    private static final List<String> ALLOWED_URIS;
    public static final Companion Companion;

    public void filter(@NotNull ContainerRequestContext context2) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Entity $receiver$iv = (Entity)BeansKt.getApplicationMetaData();
        License license2 = (License)XodusDatabase.INSTANCE.wrap(License.class, $receiver$iv, new Object[0]);
        String error2 = this.getLicenseError(license2);
        if (!(error2 == null || context2 instanceof ContainerRequest && this.isAllowedRequest((ContainerRequest)context2))) {
            this.abortWithError(context2, "License error", error2);
        }
    }

    private final boolean isAllowedRequest(ContainerRequest context2) {
        Set set2 = CollectionUtilKt.toSet((Iterable)ALLOWED_URIS, (Function1)new Function1<String, String>(context2){
            final /* synthetic */ ContainerRequest $context;

            @NotNull
            public final String invoke(@NotNull String it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                StringBuilder stringBuilder = new StringBuilder();
                URI uRI = this.$context.getBaseUri();
                Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"context.baseUri");
                return stringBuilder.append(uRI.getPath()).append(it).toString();
            }
            {
                this.$context = containerRequest;
                super(1);
            }
        });
        URI uRI = context2.getRequestUri();
        Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"context.requestUri");
        return set2.contains(uRI.getPath());
    }

    private final void abortWithError(ContainerRequestContext context2, String msg, String what) {
        Response.ResponseBuilder json = Response.status((int)403).type("application/json").encoding(StandardCharsets.UTF_8.displayName());
        context2.abortWith(json.entity((Object)new ApiError(msg, what, null, null, null, null, 60, null)).build());
    }

    private final String getLicenseError(License license2) {
        String licenseError2 = license2.getError();
        if (licenseError2 == null && CharismaLicenseChecker.isNotEnoughPermGen()) {
            return "Not enough permanent generation memory.";
        }
        if (licenseError2 == null && !license2.getSetupComplete()) {
            return "Setup not complete";
        }
        return licenseError2;
    }

    static {
        Companion = new Companion(null);
        ALLOWED_URIS = CollectionsKt.listOf((Object[])new String[]{"config", "admin/globalSettings", "admin/users/me", "admin/hostedPlan", "admin/hostedPlan/usageRetrospective", "token", "analytics", "admin/databaseBackup/settings", "admin/databaseBackup/settings/backupStatus", "admin/databaseBackup/backups"});
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ljetbrains/charisma/main/YouTrackLicenseFilter$Companion;", "", "()V", "ALLOWED_URIS", "", "", "youtrack-application"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

