/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.persistent.issue;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.List;
import jetbrains.charisma.persistent.BeansKt;
import jetbrains.charisma.persistent.Issue;
import jetbrains.charisma.persistent.IssueFolder;
import jetbrains.charisma.persistent.IssueTagOrderedIssuesProvider;
import jetbrains.charisma.persistent.OrderedIssuesProvider;
import jetbrains.charisma.persistent.Project;
import jetbrains.charisma.persistent.ProjectOrderedIssuesProvider;
import jetbrains.charisma.persistent.SavedQueryOrderedIssuesProvider;
import jetbrains.charisma.persistent.issue.CollectingOrderedEntitiesListener;
import jetbrains.charisma.persistent.issue.HierarchyNode;
import jetbrains.charisma.persistent.issue.HierarchyResult;
import jetbrains.charisma.persistent.issue.IssueNode;
import jetbrains.charisma.persistent.issue.IssueTagWithSubQueryOrderedIssuesProvider;
import jetbrains.charisma.persistent.issue.ProjectWithSubQueryOrderedIssuesProvider;
import jetbrains.charisma.persistent.issue.SavedQueryWithSubQueryOrderedIssuesProvider;
import jetbrains.charisma.persistent.issueFolders.IssueTag;
import jetbrains.charisma.persistent.issueFolders.SavedQuery;
import jetbrains.charisma.smartui.persistent.Context;
import jetbrains.exodus.database.TransientEntity;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.youtrack.api.parser.OrderedEntitiesListener;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 )2\u00020\u0001:\u0001)B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J&\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00150\u001f2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!H\u0016J\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00150\u001f2\u0006\u0010#\u001a\u00020$J$\u0010%\u001a\u00020\u00122\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00150'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001fH\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0004\u001a\u00020\u00058\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0002\u001a\u00020\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Ljetbrains/charisma/persistent/issue/IssueTreeLoader;", "", "folder", "Ljetbrains/charisma/persistent/IssueFolder;", "flatten", "", "(Ljetbrains/charisma/persistent/IssueFolder;Z)V", "context", "Ljetbrains/charisma/smartui/persistent/Context;", "getContext", "()Ljetbrains/charisma/smartui/persistent/Context;", "getFlatten", "()Z", "getFolder", "()Ljetbrains/charisma/persistent/IssueFolder;", "orderedEntitiesListener", "Ljetbrains/charisma/persistent/issue/CollectingOrderedEntitiesListener;", "addHierarchy", "", "list", "", "Ljetbrains/charisma/persistent/issue/IssueNode;", "parent", "Ljetbrains/charisma/persistent/issue/HierarchyNode;", "buildHierarchy", "Ljetbrains/charisma/persistent/issue/HierarchyResult;", "provider", "Ljetbrains/charisma/persistent/OrderedIssuesProvider;", "Ljetbrains/exodus/entitystore/Entity;", "user", "getIssuesTree", "", "query", "", "getSubTree", "issue", "Ljetbrains/charisma/persistent/Issue;", "onHierarchyBuilt", "result", "Ljava/util/ArrayList;", "iterable", "Companion", "youtrack-application"})
public class IssueTreeLoader {
    private final CollectingOrderedEntitiesListener orderedEntitiesListener;
    @NotNull
    private final Context context;
    @NotNull
    private final IssueFolder folder;
    private final boolean flatten;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public Iterable<IssueNode> getIssuesTree(@Nullable String query2) {
        OrderedIssuesProvider<Entity> orderProvider = Companion.getOrderProvider(this.folder, query2);
        HierarchyResult hierarchy = this.buildHierarchy(orderProvider, (Entity)BeansKt.getLoggedInUser(), this.context);
        ArrayList<IssueNode> result2 = new ArrayList<IssueNode>();
        Iterable $receiver$iv = hierarchy.getNodes();
        for (Object element$iv : $receiver$iv) {
            HierarchyNode it = (HierarchyNode)element$iv;
            result2.add(new IssueNode(it.getMember(), null, it.getMatches(), this.orderedEntitiesListener.isOrdered(it.getMember())));
            this.addHierarchy((List<IssueNode>)result2, it);
        }
        this.onHierarchyBuilt(result2, hierarchy.getIterable());
        return result2;
    }

    @NotNull
    public static /* synthetic */ Iterable getIssuesTree$default(IssueTreeLoader issueTreeLoader, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getIssuesTree");
        }
        if ((n & 1) != 0) {
            string = null;
        }
        return issueTreeLoader.getIssuesTree(string);
    }

    @NotNull
    public final Iterable<IssueNode> getSubTree(@NotNull Issue issue2) {
        Iterable iterable;
        Intrinsics.checkParameterIsNotNull((Object)((Object)issue2), (String)"issue");
        HierarchyResult hierarchy = this.buildHierarchy(Companion.getOrderProvider(this.folder, null), (Entity)BeansKt.getLoggedInUser(), this.context);
        HierarchyNode hierarchyNode = (HierarchyNode)hierarchy.getIndex().get(issue2.getEntityLocalId());
        if (hierarchyNode != null) {
            ArrayList<IssueNode> arrayList;
            HierarchyNode hierarchyNode2;
            HierarchyNode it = hierarchyNode2 = hierarchyNode;
            ArrayList<IssueNode> $receiver = arrayList = new ArrayList<IssueNode>();
            $receiver.add(new IssueNode(it.getMember(), null, it.getMatches(), this.orderedEntitiesListener.isOrdered(it.getMember())));
            this.addHierarchy((List<IssueNode>)$receiver, it);
            this.onHierarchyBuilt($receiver, hierarchy.getIterable());
            iterable = arrayList;
        } else {
            iterable = CollectionsKt.emptyList();
        }
        return iterable;
    }

    @NotNull
    public HierarchyResult buildHierarchy(@NotNull OrderedIssuesProvider<Entity> provider, @NotNull Entity user2, @NotNull Context context2) {
        Intrinsics.checkParameterIsNotNull(provider, (String)"provider");
        Intrinsics.checkParameterIsNotNull((Object)user2, (String)"user");
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        return this.flatten ? HierarchyNode.Companion.buildHierarchy(provider, user2, context2, null) : HierarchyNode.Companion.buildHierarchy$default(HierarchyNode.Companion, provider, user2, context2, null, 8, null);
    }

    public void onHierarchyBuilt(@NotNull ArrayList<IssueNode> result2, @NotNull Iterable<? extends Entity> iterable) {
        Intrinsics.checkParameterIsNotNull(result2, (String)"result");
        Intrinsics.checkParameterIsNotNull(iterable, (String)"iterable");
    }

    private final void addHierarchy(List<IssueNode> list, HierarchyNode parent2) {
        ArrayList<HierarchyNode> arrayList = parent2.getChildren();
        if (arrayList != null) {
            Iterable $receiver$iv = arrayList;
            for (Object element$iv : $receiver$iv) {
                HierarchyNode child = (HierarchyNode)element$iv;
                list.add(new IssueNode(child.getMember(), parent2.getMember(), child.getMatches(), this.orderedEntitiesListener.isChildOrdered(child.getMember())));
                this.addHierarchy(list, child);
            }
        }
    }

    @JsonIgnore
    @NotNull
    public final IssueFolder getFolder() {
        return this.folder;
    }

    @JsonIgnore
    public final boolean getFlatten() {
        return this.flatten;
    }

    public IssueTreeLoader(@NotNull IssueFolder folder2, boolean flatten) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)folder2), (String)"folder");
        this.folder = folder2;
        this.flatten = flatten;
        this.orderedEntitiesListener = new CollectingOrderedEntitiesListener();
        this.context = new Context((OrderedEntitiesListener)this.orderedEntitiesListener);
    }

    public /* synthetic */ IssueTreeLoader(IssueFolder issueFolder, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(issueFolder, bl);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a8\u0006\n"}, d2={"Ljetbrains/charisma/persistent/issue/IssueTreeLoader$Companion;", "", "()V", "getOrderProvider", "Ljetbrains/charisma/persistent/OrderedIssuesProvider;", "Ljetbrains/exodus/entitystore/Entity;", "issueFolder", "Ljetbrains/charisma/persistent/IssueFolder;", "query", "", "youtrack-application"})
    public static final class Companion {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @NotNull
        public final OrderedIssuesProvider<Entity> getOrderProvider(@NotNull IssueFolder issueFolder, @Nullable String query2) {
            OrderedIssuesProvider orderedIssuesProvider;
            Intrinsics.checkParameterIsNotNull((Object)((Object)issueFolder), (String)"issueFolder");
            TransientEntity entity2 = issueFolder.getEntity();
            if (query2 == null || StringsKt.isBlank((CharSequence)query2)) {
                IssueFolder issueFolder2 = issueFolder;
                if (issueFolder2 instanceof SavedQuery) {
                    orderedIssuesProvider = (OrderedIssuesProvider)new SavedQueryOrderedIssuesProvider((Entity)entity2);
                    return orderedIssuesProvider;
                } else if (issueFolder2 instanceof IssueTag) {
                    orderedIssuesProvider = (OrderedIssuesProvider)new IssueTagOrderedIssuesProvider((Entity)entity2);
                    return orderedIssuesProvider;
                } else {
                    if (!(issueFolder2 instanceof Project)) throw (Throwable)new IllegalArgumentException("Unknown issue folder");
                    orderedIssuesProvider = (OrderedIssuesProvider)new ProjectOrderedIssuesProvider((Entity)entity2);
                }
                return orderedIssuesProvider;
            } else {
                IssueFolder issueFolder3 = issueFolder;
                if (issueFolder3 instanceof SavedQuery) {
                    orderedIssuesProvider = (OrderedIssuesProvider)new SavedQueryWithSubQueryOrderedIssuesProvider(query2, (Entity)entity2);
                    return orderedIssuesProvider;
                } else if (issueFolder3 instanceof IssueTag) {
                    orderedIssuesProvider = (OrderedIssuesProvider)new IssueTagWithSubQueryOrderedIssuesProvider(query2, (Entity)entity2);
                    return orderedIssuesProvider;
                } else {
                    if (!(issueFolder3 instanceof Project)) throw (Throwable)new IllegalArgumentException("Unknown issue folder");
                    orderedIssuesProvider = (OrderedIssuesProvider)new ProjectWithSubQueryOrderedIssuesProvider(query2, (Entity)entity2);
                }
            }
            return orderedIssuesProvider;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

