/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.markup.internal;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.commonmark.node.Text;
import org.commonmark.parser.delimiter.DelimiterProcessor;
import org.commonmark.parser.delimiter.DelimiterRun;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0001J\u0010\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u0006H\u0002J\b\u0010\u000e\u001a\u00020\u0003H\u0016J\u0018\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\b\u0010\u0013\u001a\u00020\u0006H\u0016J\b\u0010\u0014\u001a\u00020\u0003H\u0016J \u0010\u0015\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Ljetbrains/youtrack/markup/internal/StaggeredDelimiterProcessor;", "Lorg/commonmark/parser/delimiter/DelimiterProcessor;", "delim", "", "(C)V", "minLength", "", "processors", "Ljava/util/LinkedList;", "add", "", "dp", "findProcessor", "len", "getClosingCharacter", "getDelimiterUse", "opener", "Lorg/commonmark/parser/delimiter/DelimiterRun;", "closer", "getMinLength", "getOpeningCharacter", "process", "Lorg/commonmark/node/Text;", "delimiterUse", "youtrack-application"})
public final class StaggeredDelimiterProcessor
implements DelimiterProcessor {
    private int minLength;
    private final LinkedList<DelimiterProcessor> processors;
    private final char delim;

    public char getOpeningCharacter() {
        return this.delim;
    }

    public char getClosingCharacter() {
        return this.delim;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public final void add(@NotNull DelimiterProcessor dp) {
        Intrinsics.checkParameterIsNotNull((Object)dp, (String)"dp");
        int len = dp.getMinLength();
        ListIterator<DelimiterProcessor> listIterator = this.processors.listIterator();
        Intrinsics.checkExpressionValueIsNotNull(listIterator, (String)"processors.listIterator()");
        ListIterator<DelimiterProcessor> it = listIterator;
        boolean added = false;
        while (it.hasNext()) {
            Object e = it.next();
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"it.next()");
            DelimiterProcessor p = (DelimiterProcessor)e;
            int pLen = p.getMinLength();
            if (len > pLen) {
                it.previous();
                it.add(dp);
                added = true;
                break;
            }
            if (len != pLen) continue;
            throw (Throwable)new IllegalArgumentException("Cannot add two delimiter processors for char '" + this.delim + "' and minimum length " + len);
        }
        if (!added) {
            this.processors.add(dp);
            this.minLength = len;
        }
    }

    private final DelimiterProcessor findProcessor(int len) {
        Iterator iterator2 = this.processors.iterator();
        while (iterator2.hasNext()) {
            DelimiterProcessor p;
            DelimiterProcessor delimiterProcessor = p = (DelimiterProcessor)iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)delimiterProcessor, (String)"p");
            if (delimiterProcessor.getMinLength() > len) continue;
            return p;
        }
        DelimiterProcessor delimiterProcessor = this.processors.getFirst();
        Intrinsics.checkExpressionValueIsNotNull((Object)delimiterProcessor, (String)"processors.first");
        return delimiterProcessor;
    }

    public int getDelimiterUse(@NotNull DelimiterRun opener, @NotNull DelimiterRun closer) {
        Intrinsics.checkParameterIsNotNull((Object)opener, (String)"opener");
        Intrinsics.checkParameterIsNotNull((Object)closer, (String)"closer");
        return this.findProcessor(opener.length()).getDelimiterUse(opener, closer);
    }

    public void process(@NotNull Text opener, @NotNull Text closer, int delimiterUse) {
        Intrinsics.checkParameterIsNotNull((Object)opener, (String)"opener");
        Intrinsics.checkParameterIsNotNull((Object)closer, (String)"closer");
        this.findProcessor(delimiterUse).process(opener, closer, delimiterUse);
    }

    public StaggeredDelimiterProcessor(char delim) {
        this.delim = delim;
        this.processors = new LinkedList();
    }
}

