/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.markup.renderer;

import java.util.Map;
import java.util.Set;
import jetbrains.charisma.main.GapUrlUtilsKt;
import jetbrains.youtrack.markup.extensions.VideoNode;
import jetbrains.youtrack.markup.renderer.AttachmentNodeRenderer;
import jetbrains.youtrack.markup.renderer.VideoNodeRenderer;
import jetbrains.youtrack.persistent.XdDraftComment;
import jetbrains.youtrack.persistent.XdIssue;
import jetbrains.youtrack.persistent.XdIssueAttachment;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.query.FilteringContext;
import kotlinx.dnq.query.XdFilteringQueryKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import org.commonmark.node.AbstractVisitor;
import org.commonmark.node.HardLineBreak;
import org.commonmark.node.Image;
import org.commonmark.node.Node;
import org.commonmark.node.SoftLineBreak;
import org.commonmark.node.Text;
import org.commonmark.node.Visitor;
import org.commonmark.renderer.NodeRenderer;
import org.commonmark.renderer.html.HtmlNodeRendererContext;
import org.commonmark.renderer.html.HtmlWriter;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u000bH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Ljetbrains/youtrack/markup/renderer/AttachmentNodeRenderer;", "Lorg/commonmark/renderer/NodeRenderer;", "context", "Lorg/commonmark/renderer/html/HtmlNodeRendererContext;", "(Lorg/commonmark/renderer/html/HtmlNodeRendererContext;)V", "html", "Lorg/commonmark/renderer/html/HtmlWriter;", "kotlin.jvm.PlatformType", "videoRenderer", "Ljetbrains/youtrack/markup/renderer/VideoNodeRenderer;", "getNodeTypes", "", "Ljava/lang/Class;", "Lorg/commonmark/node/Image;", "render", "", "node", "Lorg/commonmark/node/Node;", "tryCurrentIssueAttachments", "", "destination", "AltTextVisitor", "youtrack-application"})
public final class AttachmentNodeRenderer
implements NodeRenderer {
    private final HtmlWriter html;
    private final VideoNodeRenderer videoRenderer;
    private final HtmlNodeRendererContext context;

    @NotNull
    public Set<Class<Image>> getNodeTypes() {
        return SetsKt.setOf(Image.class);
    }

    public void render(@NotNull Node node2) {
        Intrinsics.checkParameterIsNotNull((Object)node2, (String)"node");
        Image image = (Image)node2;
        String string = image.getDestination();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"image.destination");
        if (VideoNode.Companion.looksLikeVideo(string)) {
            String string2 = image.getDestination();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"image.destination");
            this.videoRenderer.render((Node)new VideoNode(string2, image.getTitle()));
        } else {
            String string3 = image.getDestination();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"image.destination");
            String url2 = this.context.encodeUrl(this.tryCurrentIssueAttachments(string3));
            AltTextVisitor altTextVisitor = new AltTextVisitor();
            image.accept((Visitor)altTextVisitor);
            String altText = altTextVisitor.getAltText$youtrack_application();
            Map attrs = MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"src", (Object)url2), TuplesKt.to((Object)"alt", (Object)altText)});
            if (image.getTitle() != null) {
                Map map2 = attrs;
                String string4 = "title";
                String string5 = image.getTitle();
                map2.put(string4, string5);
            }
            this.html.tag("img", this.context.extendAttributes(node2, "img", attrs), true);
        }
    }

    private final String tryCurrentIssueAttachments(String destination) {
        block4: {
            XdIssueAttachment attachment2;
            XdEntity xdEntity;
            if (StringsKt.startsWith$default((String)destination, (String)"http://", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)destination, (String)"https://", (boolean)false, (int)2, null)) {
                return destination;
            }
            XdIssue xdIssue = BeansKt.getMarkdownProcessingContext().getIssue();
            if (xdIssue != null) {
                xdEntity = xdIssue;
                XdIssue issue2 = xdEntity;
                XdIssueAttachment xdIssueAttachment = attachment2 = (XdIssueAttachment)XdQueryKt.firstOrNull((XdQuery)XdFilteringQueryKt.filter((XdQuery)((XdQuery)issue2.getAttachments()), (Function2)((Function2)new Function2<FilteringContext, XdIssueAttachment, Unit>(destination){
                    final /* synthetic */ String $destination$inlined;
                    {
                        this.$destination$inlined = string;
                        super(2);
                    }

                    public final void invoke(@NotNull FilteringContext $receiver, @NotNull XdIssueAttachment it) {
                        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        $receiver.eq((Comparable)((Object)it.getName()), (Comparable)((Object)this.$destination$inlined));
                    }
                })));
                if (xdIssueAttachment != null) {
                    XdIssueAttachment xdIssueAttachment2;
                    XdIssueAttachment it = xdIssueAttachment2 = xdIssueAttachment;
                    return GapUrlUtilsKt.fileUrl$default(attachment2, null, null, !BeansKt.getMarkdownProcessingContext().getAbsoluteUrls(), 3, null);
                }
            }
            XdDraftComment xdDraftComment = (XdDraftComment)XdQueryKt.firstOrNull((XdQuery)XdFilteringQueryKt.filter((XdQuery)XdFilteringQueryKt.filter((XdQuery)XdDraftComment.Companion.all(), (Function2)tryCurrentIssueAttachments.2.INSTANCE), (Function2)tryCurrentIssueAttachments.3.INSTANCE));
            if (xdDraftComment == null) break block4;
            XdEntity draft = xdEntity = xdDraftComment;
            XdIssueAttachment xdIssueAttachment = attachment2 = (XdIssueAttachment)XdQueryKt.firstOrNull((XdQuery)XdFilteringQueryKt.filter((XdQuery)((XdQuery)draft.getAttachments()), (Function2)((Function2)new Function2<FilteringContext, XdIssueAttachment, Unit>(destination){
                final /* synthetic */ String $destination$inlined;
                {
                    this.$destination$inlined = string;
                    super(2);
                }

                public final void invoke(@NotNull FilteringContext $receiver, @NotNull XdIssueAttachment it) {
                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    $receiver.eq((Comparable)((Object)it.getName()), (Comparable)((Object)this.$destination$inlined));
                }
            })));
            if (xdIssueAttachment != null) {
                XdIssueAttachment xdIssueAttachment3;
                XdIssueAttachment it = xdIssueAttachment3 = xdIssueAttachment;
                return GapUrlUtilsKt.fileUrl$default(attachment2, null, null, !BeansKt.getMarkdownProcessingContext().getAbsoluteUrls(), 3, null);
            }
        }
        return destination;
    }

    public AttachmentNodeRenderer(@NotNull HtmlNodeRendererContext context2) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        this.context = context2;
        this.html = this.context.getWriter();
        this.videoRenderer = new VideoNodeRenderer(this.context);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00060\bj\u0002`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ljetbrains/youtrack/markup/renderer/AttachmentNodeRenderer$AltTextVisitor;", "Lorg/commonmark/node/AbstractVisitor;", "()V", "altText", "", "getAltText$youtrack_application", "()Ljava/lang/String;", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "visit", "", "hardLineBreak", "Lorg/commonmark/node/HardLineBreak;", "softLineBreak", "Lorg/commonmark/node/SoftLineBreak;", "text", "Lorg/commonmark/node/Text;", "youtrack-application"})
    private static final class AltTextVisitor
    extends AbstractVisitor {
        private final StringBuilder sb = new StringBuilder();

        @NotNull
        public final String getAltText$youtrack_application() {
            String string = this.sb.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
            return string;
        }

        public void visit(@NotNull Text text) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            this.sb.append(text.getLiteral());
        }

        public void visit(@NotNull SoftLineBreak softLineBreak) {
            Intrinsics.checkParameterIsNotNull((Object)softLineBreak, (String)"softLineBreak");
            this.sb.append('\n');
        }

        public void visit(@NotNull HardLineBreak hardLineBreak) {
            Intrinsics.checkParameterIsNotNull((Object)hardLineBreak, (String)"hardLineBreak");
            this.sb.append('\n');
        }
    }
}

